/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.MDEDescriptorTest")
public class MDEDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"MDEC-11", "MDEC-12", "MDEC-13", "MDEC-14", "MDEC-22", "MDEC-23", "MDEC-24", "MDEC-33", "MDEC-34", "MDEC-44", "MDEO-11", "MDEO-12", "MDEO-22", "MDEN-11", "MDEN-12", "MDEN-13", "MDEN-22", "MDEN-23", "MDEN-33"};
    public static final int mdec11 = 0;
    public static final int mdec12 = 1;
    public static final int mdec13 = 2;
    public static final int mdec14 = 3;
    public static final int mdec22 = 4;
    public static final int mdec23 = 5;
    public static final int mdec24 = 6;
    public static final int mdec33 = 7;
    public static final int mdec34 = 8;
    public static final int mdec44 = 9;
    public static final int mdeo11 = 10;
    public static final int mdeo12 = 11;
    public static final int mdeo22 = 12;
    public static final int mden11 = 13;
    public static final int mden12 = 14;
    public static final int mden13 = 15;
    public static final int mden22 = 16;
    public static final int mden23 = 17;
    public static final int mden33 = 18;
    private static final int C_1 = 1;
    private static final int C_2 = 2;
    private static final int C_3 = 3;
    private static final int C_4 = 4;
    private static final int O_1 = 1;
    private static final int O_2 = 2;
    private static final int N_1 = 1;
    private static final int N_2 = 2;
    private static final int N_3 = 3;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#mde", this.getClass().getName(), "$Id: 1d99a09ecb1db3b46a48d094a1a0a0812c8236df $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer local = AtomContainerManipulator.removeHydrogens(container);
        DoubleArrayResult retval = new DoubleArrayResult(19);
        for (int i = 0; i < 19; ++i) {
            retval.add(this.dedge(local, i));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(19);
    }

    private double dedge(IAtomContainer atomContainer, int which) {
        int[][] adjMatrix = AdjacencyMatrix.getMatrix(atomContainer);
        int[][] tdist = PathTools.computeFloydAPSP(adjMatrix);
        int[][] atypes = null;
        switch (which) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                atypes = this.evalATable(atomContainer, 6);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                atypes = this.evalATable(atomContainer, 8);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                atypes = this.evalATable(atomContainer, 7);
            }
        }
        double retval = 0.0;
        switch (which) {
            case 0: {
                retval = this.evalCValue(tdist, atypes, 1, 1);
                break;
            }
            case 1: {
                retval = this.evalCValue(tdist, atypes, 1, 2);
                break;
            }
            case 2: {
                retval = this.evalCValue(tdist, atypes, 1, 3);
                break;
            }
            case 3: {
                retval = this.evalCValue(tdist, atypes, 1, 4);
                break;
            }
            case 4: {
                retval = this.evalCValue(tdist, atypes, 2, 2);
                break;
            }
            case 5: {
                retval = this.evalCValue(tdist, atypes, 2, 3);
                break;
            }
            case 6: {
                retval = this.evalCValue(tdist, atypes, 2, 4);
                break;
            }
            case 7: {
                retval = this.evalCValue(tdist, atypes, 3, 3);
                break;
            }
            case 8: {
                retval = this.evalCValue(tdist, atypes, 3, 4);
                break;
            }
            case 9: {
                retval = this.evalCValue(tdist, atypes, 4, 4);
                break;
            }
            case 10: {
                retval = this.evalCValue(tdist, atypes, 1, 1);
                break;
            }
            case 11: {
                retval = this.evalCValue(tdist, atypes, 1, 2);
                break;
            }
            case 12: {
                retval = this.evalCValue(tdist, atypes, 2, 2);
                break;
            }
            case 13: {
                retval = this.evalCValue(tdist, atypes, 1, 1);
                break;
            }
            case 14: {
                retval = this.evalCValue(tdist, atypes, 1, 2);
                break;
            }
            case 15: {
                retval = this.evalCValue(tdist, atypes, 1, 3);
                break;
            }
            case 16: {
                retval = this.evalCValue(tdist, atypes, 2, 2);
                break;
            }
            case 17: {
                retval = this.evalCValue(tdist, atypes, 2, 3);
                break;
            }
            case 18: {
                retval = this.evalCValue(tdist, atypes, 3, 3);
            }
        }
        return retval;
    }

    private int[][] evalATable(IAtomContainer atomContainer, int atomicNum) {
        int natom = atomContainer.getAtomCount();
        int[][] atypes = new int[natom][2];
        for (int i = 0; i < natom; ++i) {
            IAtom atom = atomContainer.getAtom(i);
            int numConnectedBonds = atomContainer.getConnectedBondsCount(atom);
            atypes[i][1] = i;
            atypes[i][0] = atomicNum == (atom.getAtomicNumber() == null ? 0 : atom.getAtomicNumber()) ? numConnectedBonds : -1;
        }
        return atypes;
    }

    private double evalCValue(int[][] distmat, int[][] codemat, int type1, int type2) {
        int i;
        double lambda = 1.0;
        double n = 0.0;
        ArrayList<Integer> v1 = new ArrayList<Integer>();
        ArrayList<Integer> v2 = new ArrayList<Integer>();
        for (i = 0; i < codemat.length; ++i) {
            if (codemat[i][0] == type1) {
                v1.add(codemat[i][1]);
            }
            if (codemat[i][0] != type2) continue;
            v2.add(codemat[i][1]);
        }
        for (i = 0; i < v1.size(); ++i) {
            for (int j = 0; j < v2.size(); ++j) {
                int b;
                int a = (Integer)v1.get(i);
                if (a == (b = ((Integer)v2.get(j)).intValue())) continue;
                double distance = distmat[a][b];
                lambda *= distance;
                n += 1.0;
            }
        }
        if (type1 == type2) {
            lambda = Math.sqrt(lambda);
            n /= 2.0;
        }
        if (n == 0.0) {
            return 0.0;
        }
        return n / Math.pow(Math.pow(lambda, 1.0 / (2.0 * n)), 2.0);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

