/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.BondTools;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.layout.AtomPlacerTest")
public class AtomPlacer {
    public static final boolean debug = true;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomPlacer.class);
    IAtomContainer molecule = null;
    final Comparator ATOM_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            int i2;
            IAtom a1 = (IAtom)o1;
            IAtom a2 = (IAtom)o2;
            int i1 = (Integer)a1.getProperty("Weight");
            if (i1 < (i2 = ((Integer)a2.getProperty("Weight")).intValue())) {
                return -1;
            }
            if (i1 == i2) {
                return 0;
            }
            return 1;
        }
    };

    @TestMethod(value="emptyAtomsListTest,triangleTest")
    public AtomPlacer() {
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public void distributePartners(IAtom atom, IAtomContainer placedNeighbours, Point2d sharedAtomsCenter, IAtomContainer unplacedNeighbours, double bondLength) {
        double occupiedAngle = 0.0;
        IAtom[] sortedAtoms = null;
        double startAngle = 0.0;
        double addAngle = 0.0;
        double radius = 0.0;
        double remainingAngle = 0.0;
        Vector2d sharedAtomsCenterVector = new Vector2d(sharedAtomsCenter);
        Vector2d newDirection = new Vector2d(atom.getPoint2d());
        Vector2d occupiedDirection = new Vector2d(sharedAtomsCenter);
        occupiedDirection.sub(newDirection);
        logger.debug("distributePartners->occupiedDirection.lenght(): " + occupiedDirection.length());
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        logger.debug("Number of shared atoms: ", placedNeighbours.getAtomCount());
        if (placedNeighbours.getAtomCount() == 1) {
            logger.debug("Only one neighbour...");
            for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
                atomsToDraw.addElement(unplacedNeighbours.getAtom(f));
            }
            addAngle = Math.PI * 2 / (double)(unplacedNeighbours.getAtomCount() + placedNeighbours.getAtomCount());
            IAtom placedAtom = placedNeighbours.getAtom(0);
            double xDiff = placedAtom.getPoint2d().x - atom.getPoint2d().x;
            double yDiff = placedAtom.getPoint2d().y - atom.getPoint2d().y;
            logger.debug("distributePartners->xdiff: " + Math.toDegrees(xDiff));
            logger.debug("distributePartners->ydiff: " + Math.toDegrees(yDiff));
            startAngle = GeometryTools.getAngle(xDiff, yDiff);
            logger.debug("distributePartners->angle: " + Math.toDegrees(startAngle));
            this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, bondLength);
            return;
        }
        if (placedNeighbours.getAtomCount() == 0) {
            logger.debug("First atom...");
            for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
                atomsToDraw.addElement(unplacedNeighbours.getAtom(f));
            }
            addAngle = Math.PI * 2 / (double)unplacedNeighbours.getAtomCount();
            startAngle = 0.0;
            this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, bondLength);
            return;
        }
        sharedAtomsCenterVector.sub(newDirection);
        newDirection = sharedAtomsCenterVector;
        newDirection.normalize();
        newDirection.scale(bondLength);
        newDirection.negate();
        logger.debug("distributePartners->newDirection.lenght(): " + newDirection.length());
        Point2d distanceMeasure = new Point2d(atom.getPoint2d());
        distanceMeasure.add(newDirection);
        sortedAtoms = AtomContainerManipulator.getAtomArray(placedNeighbours);
        GeometryTools.sortBy2DDistance(sortedAtoms, distanceMeasure);
        Vector2d closestPoint1 = new Vector2d(sortedAtoms[0].getPoint2d());
        Vector2d closestPoint2 = new Vector2d(sortedAtoms[1].getPoint2d());
        closestPoint1.sub(new Vector2d(atom.getPoint2d()));
        closestPoint2.sub(new Vector2d(atom.getPoint2d()));
        occupiedAngle = closestPoint1.angle(occupiedDirection);
        occupiedAngle += closestPoint2.angle(occupiedDirection);
        double angle1 = GeometryTools.getAngle(sortedAtoms[0].getPoint2d().x - atom.getPoint2d().x, sortedAtoms[0].getPoint2d().y - atom.getPoint2d().y);
        double angle2 = GeometryTools.getAngle(sortedAtoms[1].getPoint2d().x - atom.getPoint2d().x, sortedAtoms[1].getPoint2d().y - atom.getPoint2d().y);
        double angle3 = GeometryTools.getAngle(distanceMeasure.x - atom.getPoint2d().x, distanceMeasure.y - atom.getPoint2d().y);
        try {
            logger.debug("distributePartners->sortedAtoms[0]: ", this.molecule.getAtomNumber(sortedAtoms[0]) + 1);
            logger.debug("distributePartners->sortedAtoms[1]: ", this.molecule.getAtomNumber(sortedAtoms[1]) + 1);
            logger.debug("distributePartners->angle1: ", Math.toDegrees(angle1));
            logger.debug("distributePartners->angle2: ", Math.toDegrees(angle2));
        }
        catch (Exception exc) {
            logger.debug(exc);
        }
        IAtom startAtom = null;
        startAtom = angle1 > angle3 ? (angle1 - angle3 < Math.PI ? sortedAtoms[1] : sortedAtoms[0]) : (angle3 - angle1 < Math.PI ? sortedAtoms[0] : sortedAtoms[1]);
        remainingAngle = Math.PI * 2 - occupiedAngle;
        addAngle = remainingAngle / (double)(unplacedNeighbours.getAtomCount() + 1);
        try {
            logger.debug("distributePartners->startAtom: " + (this.molecule.getAtomNumber(startAtom) + 1));
            logger.debug("distributePartners->remainingAngle: " + Math.toDegrees(remainingAngle));
            logger.debug("distributePartners->addAngle: " + Math.toDegrees(addAngle));
            logger.debug("distributePartners-> partners.getAtomCount(): " + unplacedNeighbours.getAtomCount());
        }
        catch (Exception exc) {
            logger.debug(exc);
        }
        for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
            atomsToDraw.addElement(unplacedNeighbours.getAtom(f));
        }
        radius = bondLength;
        startAngle = GeometryTools.getAngle(startAtom.getPoint2d().x - atom.getPoint2d().x, startAtom.getPoint2d().y - atom.getPoint2d().y);
        logger.debug("Before check: distributePartners->startAngle: " + startAngle);
        logger.debug("After check: distributePartners->startAngle: " + startAngle);
        this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, radius);
    }

    public void placeLinearChain(IAtomContainer atomContainer, Vector2d initialBondVector, double bondLength) {
        IMolecule withh = atomContainer.getBuilder().newInstance(IMolecule.class, atomContainer);
        int[] numh = new int[atomContainer.getAtomCount()];
        int n = atomContainer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            Integer tmp = atomContainer.getAtom(i).getImplicitHydrogenCount();
            numh[i] = tmp == CDKConstants.UNSET ? 0 : tmp;
        }
        logger.debug("Placing linear chain of length " + atomContainer.getAtomCount());
        Vector2d bondVector = initialBondVector;
        IAtom atom = null;
        Point2d atomPoint = null;
        IAtom nextAtom = null;
        for (int f = 0; f < atomContainer.getAtomCount() - 1; ++f) {
            atom = atomContainer.getAtom(f);
            nextAtom = atomContainer.getAtom(f + 1);
            atomPoint = new Point2d(atom.getPoint2d());
            bondVector.normalize();
            bondVector.scale(bondLength);
            atomPoint.add(bondVector);
            nextAtom.setPoint2d(atomPoint);
            nextAtom.setFlag(0, true);
            boolean trans = false;
            if (GeometryTools.has2DCoordinatesNew(atomContainer) == 2) {
                try {
                    if (f > 2 && BondTools.isValidDoubleBondConfiguration(withh, withh.getBond(withh.getAtom(f - 2), withh.getAtom(f - 1)))) {
                        trans = BondTools.isCisTrans(withh.getAtom(f - 3), withh.getAtom(f - 2), withh.getAtom(f - 1), withh.getAtom(f - 0), withh);
                    }
                }
                catch (Exception ex) {
                    logger.debug("Excpetion in detecting E/Z. This could mean that cleanup does not respect E/Z");
                }
                bondVector = this.getNextBondVector(nextAtom, atom, GeometryTools.get2DCenter(this.molecule), trans);
                continue;
            }
            bondVector = this.getNextBondVector(nextAtom, atom, GeometryTools.get2DCenter(this.molecule), true);
        }
        int n2 = atomContainer.getAtomCount();
        for (int i = 0; i < n2; ++i) {
            atomContainer.getAtom(i).setImplicitHydrogenCount(numh[i]);
        }
    }

    public Vector2d getNextBondVector(IAtom atom, IAtom previousAtom, Point2d distanceMeasure, boolean trans) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering AtomPlacer.getNextBondVector()");
            logger.debug("Arguments are atom: " + atom + ", previousAtom: " + previousAtom + ", distanceMeasure: " + distanceMeasure);
        }
        double angle = GeometryTools.getAngle(previousAtom.getPoint2d().x - atom.getPoint2d().x, previousAtom.getPoint2d().y - atom.getPoint2d().y);
        double addAngle = Math.toRadians(120.0);
        if (!trans) {
            addAngle = Math.toRadians(60.0);
        }
        if (this.shouldBeLinear(atom, this.molecule)) {
            addAngle = Math.toRadians(180.0);
        }
        Vector2d vec1 = new Vector2d(Math.cos(angle += addAngle), Math.sin(angle));
        Point2d point1 = new Point2d(atom.getPoint2d());
        point1.add(vec1);
        double distance1 = point1.distance(distanceMeasure);
        Vector2d vec2 = new Vector2d(Math.cos(angle += addAngle), Math.sin(angle));
        Point2d point2 = new Point2d(atom.getPoint2d());
        point2.add(vec2);
        double distance2 = point2.distance(distanceMeasure);
        if (distance2 > distance1) {
            logger.debug("Exiting AtomPlacer.getNextBondVector()");
            return vec2;
        }
        logger.debug("Exiting AtomPlacer.getNextBondVector()");
        return vec1;
    }

    @TestMethod(value="emptyAtomsListTest,triangleTest")
    public void populatePolygonCorners(List<IAtom> atomsToDraw, Point2d rotationCenter, double startAngle, double addAngle, double radius) {
        int i;
        double angle = startAngle;
        logger.debug("populatePolygonCorners->startAngle: ", Math.toDegrees(angle));
        Vector<Point2d> points = new Vector<Point2d>();
        logger.debug("  centerX:", rotationCenter.x);
        logger.debug("  centerY:", rotationCenter.y);
        logger.debug("  radius :", radius);
        for (i = 0; i < atomsToDraw.size(); ++i) {
            if ((angle += addAngle) >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            logger.debug("populatePolygonCorners->angle: ", Math.toDegrees(angle));
            double x = Math.cos(angle) * radius;
            double y = Math.sin(angle) * radius;
            double newX = x + rotationCenter.x;
            double newY = y + rotationCenter.y;
            logger.debug("  newX:", newX);
            logger.debug("  newY:", newY);
            points.addElement(new Point2d(newX, newY));
        }
        for (i = 0; i < atomsToDraw.size(); ++i) {
            IAtom connectAtom = atomsToDraw.get(i);
            connectAtom.setPoint2d((Point2d)points.elementAt(i));
            connectAtom.setFlag(0, true);
            if (!logger.isDebugEnabled() || connectAtom == null) continue;
            try {
                logger.debug("populatePolygonCorners->connectAtom: " + (this.molecule.getAtomNumber(connectAtom) + 1) + " placed at " + connectAtom.getPoint2d());
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    public void partitionPartners(IAtom atom, IAtomContainer unplacedPartners, IAtomContainer placedPartners) {
        List<IAtom> atoms = this.molecule.getConnectedAtomsList(atom);
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curatom = atoms.get(i);
            if (curatom.getFlag(0)) {
                placedPartners.addAtom(curatom);
                continue;
            }
            unplacedPartners.addAtom(curatom);
        }
    }

    public IAtomContainer getInitialLongestChain(IMolecule molecule) throws CDKException {
        logger.debug("Start of getInitialLongestChain()");
        double[][] conMat = ConnectionMatrix.getMatrix(molecule);
        logger.debug("Computing all-pairs-shortest-pathes");
        int[][] apsp = PathTools.computeFloydAPSP(conMat);
        int maxPathLength = 0;
        int bestStartAtom = -1;
        int bestEndAtom = -1;
        IAtom atom = null;
        IAtom startAtom = null;
        for (int f = 0; f < apsp.length; ++f) {
            atom = molecule.getAtom(f);
            if (molecule.getConnectedBondsCount(atom) != 1) continue;
            for (int g = 0; g < apsp.length; ++g) {
                if (apsp[f][g] <= maxPathLength) continue;
                maxPathLength = apsp[f][g];
                bestStartAtom = f;
                bestEndAtom = g;
            }
        }
        logger.debug("Longest chaing in molecule is of length " + maxPathLength + " between atoms " + (bestStartAtom + 1) + " and " + (bestEndAtom + 1));
        startAtom = molecule.getAtom(bestStartAtom);
        IAtomContainer path = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        path.addAtom(startAtom);
        path = this.getLongestUnplacedChain(molecule, startAtom);
        logger.debug("End of getInitialLongestChain()");
        return path;
    }

    public IAtomContainer getLongestUnplacedChain(IMolecule molecule, IAtom startAtom) throws CDKException {
        logger.debug("Start of getLongestUnplacedChain.");
        int longest = 0;
        int longestPathLength = 0;
        int maxDegreeSum = 0;
        int degreeSum = 0;
        IAtomContainer[] pathes = new IAtomContainer[molecule.getAtomCount()];
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            molecule.getAtom(f).setFlag(4, false);
            pathes[f] = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            pathes[f].addAtom(startAtom);
        }
        Vector<IAtom> startSphere = new Vector<IAtom>();
        startSphere.addElement(startAtom);
        this.breadthFirstSearch(molecule, startSphere, pathes);
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            if (pathes[f].getAtomCount() < longestPathLength || (degreeSum = this.getDegreeSum(pathes[f], molecule)) <= maxDegreeSum) continue;
            maxDegreeSum = degreeSum;
            longest = f;
            longestPathLength = pathes[f].getAtomCount();
        }
        logger.debug("End of getLongestUnplacedChain.");
        return pathes[longest];
    }

    public void breadthFirstSearch(IAtomContainer ac, Vector sphere, IAtomContainer[] pathes) throws CDKException {
        int f;
        IAtom atom = null;
        IAtom nextAtom = null;
        Vector<IAtom> newSphere = new Vector<IAtom>();
        logger.debug("Start of breadthFirstSearch");
        for (f = 0; f < sphere.size(); ++f) {
            atom = (IAtom)sphere.elementAt(f);
            if (atom.getFlag(1)) continue;
            int atomNr = ac.getAtomNumber(atom);
            logger.debug("BreadthFirstSearch around atom " + (atomNr + 1));
            List<IBond> bonds = ac.getConnectedBondsList(atom);
            for (int g = 0; g < bonds.size(); ++g) {
                IBond curBond = bonds.get(g);
                nextAtom = curBond.getConnectedAtom(atom);
                if (nextAtom.getFlag(4) || nextAtom.getFlag(0)) continue;
                int nextAtomNr = ac.getAtomNumber(nextAtom);
                logger.debug("BreadthFirstSearch is meeting new atom " + (nextAtomNr + 1));
                pathes[nextAtomNr] = ac.getBuilder().newInstance(IAtomContainer.class, pathes[atomNr]);
                logger.debug("Making copy of path " + (atomNr + 1) + " to form new path " + (nextAtomNr + 1));
                logger.debug("Old path " + (atomNr + 1) + " looks like: " + this.listNumbers(this.molecule, pathes[atomNr]));
                logger.debug("Copied path " + (nextAtomNr + 1) + " looks like: " + this.listNumbers(this.molecule, pathes[nextAtomNr]));
                pathes[nextAtomNr].addAtom(nextAtom);
                logger.debug("Adding atom " + (nextAtomNr + 1) + " to path " + (nextAtomNr + 1));
                pathes[nextAtomNr].addBond(curBond);
                logger.debug("New path " + (nextAtomNr + 1) + " looks like: " + this.listNumbers(this.molecule, pathes[nextAtomNr]));
                if (ac.getConnectedBondsCount(nextAtom) <= 1) continue;
                newSphere.addElement(nextAtom);
            }
        }
        if (newSphere.size() > 0) {
            for (f = 0; f < newSphere.size(); ++f) {
                ((IAtom)newSphere.elementAt(f)).setFlag(4, true);
            }
            this.breadthFirstSearch(ac, newSphere, pathes);
        }
        logger.debug("End of breadthFirstSearch");
    }

    public String listPlaced(IAtomContainer ac) {
        String s = "Placed: ";
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            s = ac.getAtom(f).getFlag(0) ? s + (f + 1) + "+ " : s + (f + 1) + "- ";
        }
        return s;
    }

    public String listNumbers(IAtomContainer mol, IAtomContainer ac) throws CDKException {
        String s = "Numbers: ";
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            s = s + (mol.getAtomNumber(ac.getAtom(f)) + 1) + " ";
        }
        return s;
    }

    public String listNumbers(IAtomContainer mol, Vector ac) throws Exception {
        String s = "Numbers: ";
        for (int f = 0; f < ac.size(); ++f) {
            s = s + (mol.getAtomNumber((IAtom)ac.elementAt(f)) + 1) + " ";
        }
        return s;
    }

    public boolean allPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (ac.getAtom(f).getFlag(0)) continue;
            return false;
        }
        return true;
    }

    public void markNotPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(0, false);
        }
    }

    public void markPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(0, true);
        }
    }

    public IAtomContainer getPlacedAtoms(IAtomContainer ac) {
        IAtomContainer ret = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (!ac.getAtom(f).getFlag(0)) continue;
            ret.addAtom(ac.getAtom(f));
        }
        return ret;
    }

    int getDegreeSum(IAtomContainer ac, IAtomContainer superAC) {
        int degreeSum = 0;
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            degreeSum += superAC.getConnectedBondsCount(ac.getAtom(f));
        }
        return degreeSum;
    }

    void calculateWeights(IAtomContainer ac) {
        int[] weights = this.getWeightNumbers(ac);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setProperty("Weight", new Integer(weights[f]));
        }
    }

    int[] getWeightNumbers(IAtomContainer atomContainer) {
        int N = atomContainer.getAtomCount();
        int[] morganMatrix = new int[N];
        int[] tempMorganMatrix = new int[N];
        List<IAtom> atoms = null;
        for (int f = 0; f < N; ++f) {
            morganMatrix[f] = atomContainer.getConnectedBondsCount(f);
            tempMorganMatrix[f] = atomContainer.getConnectedBondsCount(f);
        }
        for (int e = 0; e < N; ++e) {
            for (int f = 0; f < N; ++f) {
                morganMatrix[f] = 0;
                atoms = atomContainer.getConnectedAtomsList(atomContainer.getAtom(f));
                for (int g = 0; g < atoms.size(); ++g) {
                    IAtom atom = atoms.get(g);
                    if (atom.getFlag(0)) continue;
                    int n = f;
                    morganMatrix[n] = morganMatrix[n] + tempMorganMatrix[atomContainer.getAtomNumber(atom)];
                }
            }
            System.arraycopy(morganMatrix, 0, tempMorganMatrix, 0, N);
        }
        return tempMorganMatrix;
    }

    public boolean shouldBeLinear(IAtom atom, IAtomContainer molecule) {
        int sum = 0;
        List<IBond> bonds = molecule.getConnectedBondsList(atom);
        for (int g = 0; g < bonds.size(); ++g) {
            IBond bond = bonds.get(g);
            if (bond.getOrder() == IBond.Order.TRIPLE) {
                sum += 10;
                continue;
            }
            if (bond.getOrder() != IBond.Order.SINGLE) continue;
            ++sum;
        }
        return sum >= 10;
    }
}

