/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.AppendAtom;
import org.openscience.cdk.controller.edit.SetStereo;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.selection.AbstractSelection;

public class AlterBondStereoModule
extends ControllerModuleAdapter {
    IBond.Stereo[] switchOrderUp = new IBond.Stereo[]{IBond.Stereo.UP, IBond.Stereo.UP_INVERTED, IBond.Stereo.NONE};
    IBond.Stereo[] switchOrderDown = new IBond.Stereo[]{IBond.Stereo.DOWN, IBond.Stereo.DOWN_INVERTED, IBond.Stereo.NONE};
    private IBond.Stereo desiredDirection;

    public AlterBondStereoModule(IChemModelRelay chemModelRelay, IChemModelRelay.Direction desiredDirection) {
        super(chemModelRelay);
        this.desiredDirection = desiredDirection == IChemModelRelay.Direction.UP ? IBond.Stereo.UP : IBond.Stereo.DOWN;
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IAtom atom = this.chemModelRelay.getClosestAtom(worldCoord);
        IBond bond = this.chemModelRelay.getClosestBond(worldCoord);
        IChemObject singleSelection = this.getHighlighted(worldCoord, new IChemObject[]{atom, bond});
        if (singleSelection == null) {
            this.setSelection(AbstractSelection.EMPTY_SELECTION);
        } else if (singleSelection instanceof IAtom) {
            this.chemModelRelay.execute(AppendAtom.appendAtom("C", atom, this.desiredDirection));
        } else if (singleSelection instanceof IBond) {
            IBond.Stereo bondStereo = bond.getStereo();
            switch (this.desiredDirection) {
                case UP: {
                    this.setStereo(bond, this.findNextStereoMode(bondStereo, this.switchOrderUp));
                    break;
                }
                case DOWN: {
                    this.setStereo(bond, this.findNextStereoMode(bondStereo, this.switchOrderDown));
                }
            }
        } else {
            this.setStereo(bond, this.desiredDirection);
        }
    }

    private void setStereo(IBond bond, IBond.Stereo mode) {
        this.chemModelRelay.execute(SetStereo.setStereo(bond, mode));
    }

    private IBond.Stereo findNextStereoMode(IBond.Stereo current, IBond.Stereo[] switchOrder) {
        for (int i = 0; i < switchOrder.length; ++i) {
            if (current != switchOrder[i]) continue;
            return switchOrder[i + 1 == switchOrder.length ? 0 : i + 1];
        }
        return switchOrder[0];
    }

    @Override
    public String getDrawModeString() {
        if (this.desiredDirection == IBond.Stereo.UP) {
            return "Add or convert to bond up";
        }
        return "Add or convert to bond down";
    }
}

