/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import nu.xom.Attribute;
import org.xmlcml.cml.base.CMLAttribute;

public class BooleanSTAttribute
extends CMLAttribute {
    public static final String JAVA_TYPE = "boolean";
    public static final String JAVA_GET_METHOD = "getBoolean";
    public static final String JAVA_SHORT_CLASS = "BooleanSTAttribute";
    protected Boolean b;

    public BooleanSTAttribute(String name) {
        super(name);
    }

    public BooleanSTAttribute(Attribute att) {
        this(att.getLocalName());
        String v = att.getValue();
        if (v != null && !v.trim().equals("")) {
            this.setCMLValue(v);
        }
    }

    public BooleanSTAttribute(BooleanSTAttribute att) {
        super(att);
        if (att.b != null) {
            this.b = new Boolean(att.b);
        }
    }

    public BooleanSTAttribute(Attribute att, String value) {
        super(att, value.trim().replace("\\s+", " "));
    }

    public void setCMLValue(String s) {
        boolean i;
        try {
            i = Boolean.parseBoolean(s.trim());
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("" + nfe);
        }
        this.setCMLValue(i);
    }

    public void setCMLValue(boolean i) {
        this.checkValue(i);
        this.b = new Boolean(i);
        this.setValue("" + i);
    }

    public void checkValue(boolean b) {
        if (this.cmlType != null) {
            this.cmlType.checkValue(b);
        }
    }

    public Object getCMLValue() {
        return this.b;
    }

    public boolean getBoolean() {
        if (this.b == null) {
            throw new RuntimeException("booleaneger attribute unset");
        }
        return this.b;
    }

    public String getJavaType() {
        return JAVA_TYPE;
    }

    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

