/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.reaction.type.ElectronImpactPDBReactionTest")
public class ElectronImpactPDBReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElectronImpactPDBReaction.class);

    @Override
    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#ElectronImpactPDB", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_IMoleculeSet")
    public IReactionSet initiate(IMoleculeSet reactants, IMoleculeSet agents) throws CDKException {
        logger.debug("initiate reaction: ElectronImpactPDBReaction");
        if (reactants.getMoleculeCount() != 1) {
            throw new CDKException("ElectronImpactPDBReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("ElectronImpactPDBReaction don't expects agents");
        }
        IReactionSet setOfReactions = DefaultChemObjectBuilder.getInstance().newInstance(IReactionSet.class, new Object[0]);
        IMolecule reactant = reactants.getMolecule(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IBond bondi : reactant.bonds()) {
            IAtom atom1 = bondi.getAtom(0);
            IAtom atom2 = bondi.getAtom(1);
            if (!bondi.getFlag(10) || bondi.getOrder() != IBond.Order.DOUBLE && bondi.getOrder() != IBond.Order.TRIPLE || !atom1.getFlag(10) || !atom2.getFlag(10) || (atom1.getFormalCharge() == CDKConstants.UNSET ? 0 : atom1.getFormalCharge()) != 0 || (atom2.getFormalCharge() == CDKConstants.UNSET ? 0 : atom2.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atom1) != 0 || reactant.getConnectedSingleElectronsCount(atom2) != 0) continue;
            for (int j = 0; j < 2; ++j) {
                ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                if (j == 0) {
                    atomList.add(atom1);
                    atomList.add(atom2);
                } else {
                    atomList.add(atom2);
                    atomList.add(atom1);
                }
                ArrayList<IBond> bondList = new ArrayList<IBond>();
                bondList.add(bondi);
                IMoleculeSet moleculeSet = reactant.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                moleculeSet.addMolecule(reactant);
                IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                if (reaction == null) continue;
                setOfReactions.addReaction(reaction);
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IMolecule reactant) throws CDKException {
        for (IBond bondi : reactant.bonds()) {
            IAtom atom1 = bondi.getAtom(0);
            IAtom atom2 = bondi.getAtom(1);
            if (bondi.getOrder() != IBond.Order.DOUBLE && bondi.getOrder() != IBond.Order.TRIPLE || (atom1.getFormalCharge() == CDKConstants.UNSET ? 0 : atom1.getFormalCharge()) != 0 || (atom2.getFormalCharge() == CDKConstants.UNSET ? 0 : atom2.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atom1) != 0 || reactant.getConnectedSingleElectronsCount(atom2) != 0) continue;
            bondi.setFlag(10, true);
            atom1.setFlag(10, true);
            atom2.setFlag(10, true);
        }
    }
}

