/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.guha.rcdk.view.RowLabelRenderer;
import org.guha.rcdk.view.panels.JmolPanel;
import org.guha.rcdk.view.table.StructureTableCellEditor3D;
import org.guha.rcdk.view.table.StructureTableCellRenderer3D;
import org.guha.rcdk.view.table.StructureTableModel;
import org.jmol.api.JmolViewer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;

class StructureTable3D {
    private IAtomContainer[] v;
    private int cellx = 200;
    private int celly = 200;
    private int ncol = 4;

    public StructureTable3D(IAtomContainer[] structs) {
        this.v = structs;
    }

    public StructureTable3D(IAtomContainer[] structs, int ncol) {
        this.v = structs;
        this.ncol = ncol;
    }

    public StructureTable3D(IAtomContainer[] structs, int ncol, int cellx, int celly) {
        this.v = structs;
        this.ncol = ncol;
        this.cellx = cellx;
        this.celly = celly;
    }

    private ChemFile getAsChemFile(IAtomContainer atomContainer) {
        MoleculeSet moleculeSet = new MoleculeSet();
        moleculeSet.addMolecule((IMolecule)new Molecule(atomContainer));
        ChemModel model = new ChemModel();
        model.setMoleculeSet((IMoleculeSet)moleculeSet);
        ChemSequence sequence = new ChemSequence();
        sequence.addChemModel((IChemModel)model);
        ChemFile chemFile = new ChemFile();
        chemFile.addChemSequence((IChemSequence)sequence);
        return chemFile;
    }

    public void display() {
        String strError;
        JmolViewer viewer;
        int j;
        int i;
        int pad = 10;
        String[] nm = new String[this.ncol + 1];
        int extra = this.v.length % this.ncol;
        int block = this.v.length - extra;
        int nrow = block / this.ncol;
        Object[][] ndata = extra == 0 ? new Object[nrow][this.ncol + 1] : new Object[nrow + 1][this.ncol + 1];
        int cnt = 0;
        for (i = 0; i < nrow; ++i) {
            for (j = 1; j < this.ncol + 1; ++j) {
                ndata[i][j] = new JmolPanel();
                ((JmolPanel)ndata[i][j]).setSize(this.cellx, this.celly);
                viewer = ((JmolPanel)ndata[i][j]).getViewer();
                viewer.openClientFile("", "", (Object)this.getAsChemFile(this.v[cnt]));
                strError = viewer.getOpenFileError();
                if (strError != null) {
                    System.out.println(strError);
                }
                ++cnt;
            }
        }
        j = 1;
        while (cnt < this.v.length) {
            ndata[nrow][j] = new JmolPanel();
            ((JmolPanel)ndata[i][j]).setSize(this.cellx, this.celly);
            viewer = ((JmolPanel)ndata[nrow][j]).getViewer();
            viewer.openClientFile("", "", (Object)this.getAsChemFile(this.v[cnt]));
            strError = viewer.getOpenFileError();
            if (strError != null) {
                System.out.println(strError);
            }
            ++cnt;
            ++j;
        }
        if (extra != 0) {
            ++nrow;
        }
        for (i = 0; i < nrow; ++i) {
            ndata[i][0] = i * this.ncol + 1;
        }
        JFrame frame = new JFrame("3D Structure Grid");
        frame.setDefaultCloseOperation(2);
        JTable mtable = new JTable(new StructureTableModel(ndata, nm));
        mtable.setShowGrid(true);
        for (i = 0; i < nrow; ++i) {
            mtable.setRowHeight(i, this.celly);
        }
        mtable.setColumnSelectionAllowed(true);
        mtable.setRowSelectionAllowed(true);
        TableColumn col = mtable.getColumnModel().getColumn(0);
        col.setCellRenderer(new RowLabelRenderer());
        for (i = 1; i < this.ncol + 1; ++i) {
            col = mtable.getColumnModel().getColumn(i);
            col.setCellRenderer(new StructureTableCellRenderer3D());
            col.setCellEditor(new StructureTableCellEditor3D());
        }
        JScrollPane scrollpane = new JScrollPane(mtable, 20, 30);
        if (nrow > 3) {
            mtable.setPreferredScrollableViewportSize(new Dimension(this.ncol * this.cellx + pad, 3 * this.celly + pad));
        } else {
            mtable.setPreferredScrollableViewportSize(new Dimension(this.ncol * this.cellx + pad, nrow * this.celly + pad));
        }
        frame.getContentPane().add(scrollpane);
        frame.pack();
        if (nrow > 3) {
            frame.setSize(this.ncol * this.cellx + pad, 3 * this.celly + pad);
        } else {
            frame.setSize(this.ncol * this.cellx + pad, nrow * this.celly + pad);
        }
        frame.setVisible(true);
    }
}

