/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.renderer.progz.IJava2DRenderer;
import org.openscience.cdk.renderer.progz.Java2DRenderer;

public class Swing2DPainter
extends JComponent {
    private Renderer2DModel rendererModel = new Renderer2DModel();
    private IJava2DRenderer renderer = new Java2DRenderer(this.rendererModel);
    private IMolecule molecule;
    private Graphics2D graphics;
    AffineTransform affinelast = new AffineTransform();

    public Swing2DPainter() {
        this(300, 300);
    }

    public Swing2DPainter(int x, int y) {
        Dimension screenSize = new Dimension(x, y);
        this.setPreferredSize(screenSize);
        this.rendererModel.setScaleFactor(1.0);
        this.rendererModel.setBackgroundDimension(screenSize);
        this.rendererModel.setDrawNumbers(false);
        this.rendererModel.setUseAntiAliasing(true);
        this.rendererModel.setColorAtomsByType(true);
        this.rendererModel.setShowImplicitHydrogens(false);
        this.rendererModel.setShowAromaticity(true);
    }

    public void setMolecule(IMolecule molecule) {
        this.molecule = molecule;
    }

    public IJava2DRenderer getRenderer() {
        return this.renderer;
    }

    public Renderer2DModel getModel() {
        return this.rendererModel;
    }

    public IMolecule getMolecule() {
        return this.molecule;
    }

    public Graphics2D getGraphics2D() {
        return this.graphics;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.graphics = (Graphics2D)g;
        this.rendererModel.setZoomFactor(this.rendererModel.getScaleFactor());
        Color bg = this.rendererModel.getBackColor();
        g.setColor(bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.affinelast.equals(this.graphics.getTransform())) {
            this.affinelast = this.graphics.getTransform();
        }
        this.renderer.paintMolecule((IAtomContainer)this.molecule, (Graphics2D)g, (Rectangle2D)this.getBounds());
    }
}

