% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/canvec.R
\name{canvec.export}
\alias{canvec.export}
\title{Export CanVec Data}
\usage{
canvec.export(ntsid, tofolder, layerids = NULL, cachedir = NULL)
}
\arguments{
\item{ntsid}{One or more NTS References as generated by \code{nts()}}

\item{tofolder}{A directory to which files should be copied.}

\item{layerids}{One or more layer ids as listed in \code{canvec_layers$id}. Defaults to
all layers.}

\item{cachedir}{Pass a specific cache directory in which files have been extracted.
                 Default value is that returned by \code{canvec.cachedir()}}
}
\description{
Export \code{layerids} for one or more NTS reference(s) \code{ntsid} to path \code{tofolder},
automatically renaming layers based on their layerid. Generates warnings if files
cannot be found.
}
\examples{
\donttest{
canvec.export(nts("21h01"), "~/canvecdata", layerids=c("road", "river"))
}
}

