% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_opt_sky_coef.R
\name{read_opt_sky_coef}
\alias{read_opt_sky_coef}
\title{Read optimized sky coefficients}
\usage{
read_opt_sky_coef(path_to_HSP_project, img_name)
}
\arguments{
\item{path_to_HSP_project}{Character vector of length one. Path to the HSP
project folder. For instance,
"C:/Users/johndoe/Documents/HSP/Projects/my_prj/".}

\item{img_name}{Character vector of length one. For instance, "DSCN6342.pgm"
or "DSCN6342". See details.}
}
\value{
Numeric vector of length five.
}
\description{
Read optimized CIE sky coefficients stored in an HSP project.
}
\details{
Refer to the Details section of function
\code{\link[=write_sky_points]{write_sky_points()}}.
}
\seealso{
\code{\link[=cie_sky_model_raster]{cie_sky_model_raster()}}

Other HSP Functions: 
\code{\link{read_manual_input}()},
\code{\link{row_col_from_zenith_azimuth}()},
\code{\link{write_sky_points}()},
\code{\link{write_sun_coord}()},
\code{\link{zenith_azimuth_from_row_col}()}
}
\concept{HSP Functions}
