% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_caim.R
\name{write_caim}
\alias{write_caim}
\title{Write canopy image}
\usage{
write_caim(caim, path, bit_depth)
}
\arguments{
\item{caim}{\linkS4class{Raster}.}

\item{path}{Character vector of length one. Path for writing the image.}

\item{bit_depth}{Numeric vector of length one.}
}
\value{
No return value. Called for side effects.
}
\description{
Wrapper function for \code{\link[raster]{writeRaster}}.
}
\examples{
\dontrun{
caim <- read_caim() \%>\% normalize(., 0, 255)
write_caim(caim * 2^8, file.path(tmpDir(), "test_8bit"), 8)
write_caim(caim * 2^16, file.path(tmpDir(), "test_16bit"), 16)
}
}
\seealso{
\code{\link{write_bin}}

Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{extract_feature}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_bin}()}
}
\concept{Tools functions}
