% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bin.R
\name{read_bin}
\alias{read_bin}
\title{Read binarized images}
\usage{
read_bin(path)
}
\arguments{
\item{path}{One-length character vector. Path to read or a binarized image.}
}
\value{
An object from class \linkS4class{RasterLayer}.
}
\description{
Wrapper functions for \code{\link[raster]{raster}}.
}
\examples{
\dontrun{
z <- zenith_image(1000, lens())
m <- !is.na(z)
my_file <- file.path(tmpDir(), "mask.tif")
write_bin(m, my_file)
m_from_disk <- read_bin(my_file)
plot(m - m_from_disk)
}
}
\seealso{
\code{\link{write_bin}}

Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{extract_feature}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
