% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsmeans.R
\name{lsmeans}
\alias{lsmeans}
\title{Least Square Means}
\usage{
lsmeans(model, ..., .weights = c("proportional", "equal"))
}
\arguments{
\item{model}{A model created by \code{lm}.}

\item{...}{Fixes specific variables to specific values i.e.
\code{trt = 1} or \code{age = 50}. The name of the argument must be the name
of the variable within the dataset.}

\item{.weights}{Character, specifies whether to use "proportional" or "equal" weighting for each
categorical covariate combination when calculating the lsmeans.}
}
\description{
Estimates the least square means from a linear model. This is done by
generating a prediction from the model using an hypothetical observation
that is constructed by averaging the data. See details for more information.
}
\details{
The lsmeans are obtained by calculating hypothetical patients
and predicting their expected values. These hypothetical patients
are constructed by expanding out all possible combinations of each
categorical covariate and by setting any numerical covariates equal
to the mean.

A final lsmean value is calculating by averaging these hypothetical
patients. If \code{.weights} equals \code{"proportional"} then the values are weighted
by the frequency in which they occour in the full dataset. If \code{.weights}
equals \code{"equal"} then each hypothetical patient is given an equal weight
regardless of what actually occours in the dataset.

Use the \code{...} argument to fix specific variables to specific values.

See the references for identical implementations as done in SAS and
in R via the \code{emmeans} package. This function attempts to re-implement the
\code{emmeans} derivation for standard linear models but without having to include
all of it's dependencies.
}
\examples{
\dontrun{
mod <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lsmeans(mod)
lsmeans(mod, Species = "virginica")
lsmeans(mod, Species = "versicolor")
lsmeans(mod, Species = "versicolor", Petal.Length = 1)
}
}
\references{
\url{https://CRAN.R-project.org/package=emmeans}

\url{https://documentation.sas.com/doc/en/pgmsascdc/9.4_3.3/statug/statug_glm_details41.htm}
}
