% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.r
\name{stats_boxplot}
\alias{stats_boxplot}
\title{Visualize categorical metadata effects on numeric values.}
\usage{
stats_boxplot(
  df,
  x = NULL,
  y = attr(df, "response"),
  layers = "x",
  stat.by = x,
  facet.by = NULL,
  colors = TRUE,
  shapes = TRUE,
  patterns = FALSE,
  test = "auto",
  flip = FALSE,
  stripe = NULL,
  ci = "ci",
  level = 0.95,
  p.adj = "fdr",
  p.top = Inf,
  outliers = NULL,
  xlab.angle = "auto",
  p.label = 0.05,
  caption = TRUE,
  ...
)
}
\arguments{
\item{df}{The dataset (data.frame or tibble object). "Dataset fields"
mentioned below should match column names in \code{df}. Required.}

\item{x}{A categorical metadata column name to use for the x-axis. Or
\code{NULL}, which groups all samples into a single category.}

\item{y}{A numeric metadata column name to use for the y-axis.
Default: \code{attr(df, 'response')}}

\item{layers}{One or more of
\code{c("bar", "box" ("x"), "violin", "dot", "strip", "crossbar", "errorbar", "linerange", "pointrange")}.
Single letter abbreviations are also accepted. For instance,
\code{c("box", "dot")} is equivalent to \code{c("x", "d")} and \code{"xd"}.
Default: \code{"x"}}

\item{stat.by}{Dataset field with the statistical groups. Must be
categorical. Default: \code{NULL}}

\item{facet.by}{Dataset field(s) to use for faceting. Must be categorical.
Default: \code{NULL}}

\item{colors}{How to color the groups. Options are:
\describe{
\item{\code{TRUE} - }{ Automatically select colorblind-friendly colors. }
\item{\code{FALSE} or \code{NULL} - }{ Don't use colors. }
\item{a palette name - }{ Auto-select colors from this set. E.g. \code{"okabe"} }
\item{character vector - }{ Custom colors to use. E.g. \code{c("red", "#00FF00")} }
\item{named character vector - }{ Explicit mapping. E.g. \code{c(Male = "blue", Female = "red")} }
}
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{shapes}{Shapes for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, shape
names (typically integers 0 - 17), or a named vector mapping
groups to specific shape names.
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{patterns}{Patterns for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, pattern
names (\code{"brick"}, \code{"chevron"}, \code{"fish"}, \code{"grid"}, etc), or a named
vector mapping groups to specific pattern names.
See "Aesthetics" section below for additional information.
Default: \code{FALSE}}

\item{test}{Method for computing p-values: \code{'auto'} or \code{'none'}. \code{'auto'}
will choose Wilcox or Kruskal-Wallis depending on the number of
groups.}

\item{flip}{Transpose the axes, so that taxa are present as rows instead
of columns. Default: \code{FALSE}}

\item{stripe}{Shade every other x position. Default: \emph{same as flip}}

\item{ci}{How to calculate min/max of the \bold{crossbar},
\bold{errorbar}, \bold{linerange}, and \bold{pointrange} layers.
Options are: \code{"ci"} (confidence interval), \code{"range"},
\code{"sd"} (standard deviation), \code{"se"} (standard error), and
\code{"mad"} (median absolute deviation).
The center mark of \bold{crossbar} and \bold{pointrange} represents
the mean, except for \code{"mad"} in which case it represents the median.
Default: \code{"ci"}}

\item{level}{The confidence level for calculating a confidence interval.
Default: \code{0.95}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}

\item{p.top}{Only display taxa with the most significant differences in
abundance. If \code{p.top} is >= 1, then the \code{p.top} most
significant taxa are displayed. If \code{p.top} is less than one, all
taxa with an adjusted p-value <= \code{p.top} are displayed.
Recommended to be used in combination with the \code{taxa} parameter
to set a lower bound on the mean abundance of considered taxa.
Default: \code{Inf}}

\item{outliers}{Show boxplot outliers? \code{TRUE} to always show.
\code{FALSE} to always hide. \code{NULL} to only hide them when
overlaying a dot or strip chart.  Default: \code{NULL}}

\item{xlab.angle}{Angle of the labels at the bottom of the plot.
Options are \code{"auto"}, \code{'0'}, \code{'30'}, and \code{'90'}.
Default: \code{"auto"}.}

\item{p.label}{Minimum adjusted p-value to display on the plot with a
bracket.
\describe{
\item{\code{p.label = 0.05} - }{ Show p-values that are <= 0.05. }
\item{\code{p.label = 0} - }{ Don't show any p-values on the plot. }
\item{\code{p.label = 1} - }{ Show all p-values on the plot. }
}
If a numeric vector with more than one value is
provided, they will be used as breaks for asterisk notation.
Default: \code{0.05}}

\item{caption}{Add methodology caption beneath the plot.
Default: \code{TRUE}}

\item{...}{Additional parameters to pass along to ggplot2 functions.
Prefix a parameter name with a layer name to pass it to only that
layer. For instance, \code{d.size = 2} ensures only the points on the
\bold{dot} layer have their size set to \code{2}.}
}
\value{
A \code{ggplot2} plot. The computed data points, ggplot2 command,
stats table, and stats table commands are available as \verb{$data},
\verb{$code}, \verb{$stats}, and \verb{$stats$code}, respectively.
}
\description{
Visualize categorical metadata effects on numeric values.
}
\section{Aesthetics}{


All built-in color palettes are colorblind-friendly. The available
categorical palette names are: \code{"okabe"}, \code{"carto"}, \code{"r4"},
\code{"polychrome"}, \code{"tol"}, \code{"bright"}, \code{"light"},
\code{"muted"}, \code{"vibrant"}, \code{"tableau"}, \code{"classic"},
\code{"alphabet"}, \code{"tableau20"}, \code{"kelly"}, and \code{"fishy"}.

Patterns are added using the fillpattern R package. Options are \code{"brick"},
\code{"chevron"}, \code{"fish"}, \code{"grid"}, \code{"herringbone"}, \code{"hexagon"}, \code{"octagon"},
\code{"rain"}, \code{"saw"}, \code{"shingle"}, \code{"rshingle"}, \code{"stripe"}, and \code{"wave"},
optionally abbreviated and/or suffixed with modifiers. For example,
\code{"hex10_sm"} for the hexagon pattern rotated 10 degrees and shrunk by 2x.
See \code{\link[fillpattern:fill_pattern]{fillpattern::fill_pattern()}} for complete documentation of options.

Shapes can be given as per base R - numbers 0 through 17 for various shapes,
or the decimal value of an ascii character, e.g. a-z = 65:90; A-Z = 97:122 to use
letters instead of shapes on the plot. Character strings may used as well.
}

\examples{
    library(rbiom)
    
    df <- adiv_table(rarefy(hmp50))
    stats_boxplot(df, x = "Body Site")
    stats_boxplot(df, x = "Sex", stat.by = "Body Site", layers = "be")
}
\seealso{
Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()}
}
\concept{visualization}
