% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefy.r
\name{rarefy}
\alias{rarefy}
\title{Rarefy OTU counts.}
\usage{
rarefy(biom, depth = 0.1, n = NULL, seed = 0, clone = TRUE, cpus = NULL)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{depth}{How many observations to keep per sample. When
\verb{0 < depth < 1}, it is taken as the minimum percentage of the
dataset's observations to keep. Ignored when \code{n} is specified.
Default: \code{0.1}}

\item{n}{The number of samples to keep. When \verb{0 < n < 1}, it is taken as
the percentage of samples to keep. If negative, that number or
percentage of samples is dropped. If \code{0}, all samples are kept. If
\code{NULL}, \code{depth} is used instead.
Default: \code{NULL}}

\item{seed}{An integer seed for randomizing which observations to keep or
drop. If you need to create different random rarefactions of the same
data, set the seed to a different number each time.}

\item{clone}{Create a copy of \code{biom} before modifying. If \code{FALSE}, \code{biom}
is modified in place as a side-effect. See \link[=speed]{speed ups} for
use cases. Default: \code{TRUE}}

\item{cpus}{The number of CPUs to use. Set to \code{NULL} to use all available,
or to \code{1} to disable parallel processing. Default: \code{NULL}}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
Sub-sample OTU observations such that all samples have an equal number.
If called on data with non-integer abundances, values will be re-scaled to
integers between 1 and \code{depth} such that they sum to \code{depth}.
}
\examples{
    library(rbiom)
    
    sample_sums(hmp50) \%>\% head()
    
    biom <- rarefy(hmp50)
    sample_sums(biom) \%>\% head()

}
\seealso{
Other rarefaction: 
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{rarefy_cols}()},
\code{\link{sample_sums}()}

Other transformations: 
\code{\link{modify_metadata}},
\code{\link{rarefy_cols}()},
\code{\link{slice_metadata}},
\code{\link{subset}()},
\code{\link{with}()}
}
\concept{rarefaction}
\concept{transformations}
