% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{proxy.ghost}
\alias{proxy.ghost}
\title{Proxies analysed along the depths of a core can be plotted as 'proxy-ghost' graphs against calendar time while taking into account chronological uncertainties. Here darker grey indicates more likely calendar ages for specific proxy values.}
\usage{
proxy.ghost(
  proxy = 1,
  proxy.lab = NULL,
  proxy.res = 250,
  age.res = 200,
  yr.res = age.res,
  rgb.scale = c(0, 0, 0),
  rgb.res = 100,
  set = get("info"),
  dark = 1,
  darkest = 1,
  rotate.axes = FALSE,
  proxy.rev = FALSE,
  age.rev = FALSE,
  yr.rev = age.rev,
  plot.mean = FALSE,
  mean.col = "red",
  age.lim = NULL,
  yr.lim = age.lim,
  proxy.lim = NULL,
  sep = ",",
  xaxs = "i",
  yaxs = "i",
  xaxt = "s",
  yaxt = "s",
  bty = "l",
  BCAD = set$BCAD,
  age.lab = ifelse(BCAD, "BC/AD", "cal yr BP"),
  yr.lab = age.lab,
  verbose = TRUE,
  add = FALSE
)
}
\arguments{
\item{proxy}{Which proxy to use (counting from the column number in the .csv file after the depths column).}

\item{proxy.lab}{Label of the proxy axis. Default names are taken from the csv file.}

\item{proxy.res}{Greyscale pixels are calculated for \code{proxy.res=250} proxy values by default, as a compromise between image quality and calculation speed. If the output looks very pixel-like (e.g., when choosing to plot only part of the record using proxy.lim), set this option to higher values.}

\item{age.res}{Resolution or amount of greyscale pixels to cover the age scale of the age-model plot. Default \code{age.res=250} as a compromise between image quality and calculation speed. If the output looks very pixel-like (e.g., when choosing to plot only part of the record using age.lim), set this option to higher values.}

\item{yr.res}{Deprecated - use age.res instead}

\item{rgb.scale}{The function to produce a coloured representation of all age-models. Needs 3 values for the intensity of red, green and blue. Defaults to grey-scales: \code{rgb.scale=c(0,0,0)}, but could also be, say, scales of red (\code{rgb.scale=c(1,0,0)}).}

\item{rgb.res}{Resolution of the colour spectrum depicting the age-depth model. Default \code{rgb.res=100}.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{dark}{By default, the darkest grey value is assigned to the most likely value within the entire core (normalised to 1; \code{dark=1}). By setting dark to, e.g., \code{dark=.8}, all values of and above 0.8 will be darkest (and values below that threshold will be lighter grey the lower their probabilities).}

\item{darkest}{Darkness of the most likely value. Is black by default (\code{darkest=1}); lower values will result in lighter grey.}

\item{rotate.axes}{The default is to plot the calendar horizontally, however the plot can be rotated (\code{rotate.axes=TRUE}).}

\item{proxy.rev}{The proxy axis can be reversed if \code{proxy.rev=TRUE}.}

\item{age.rev}{The calendar axis can be reversed using \code{yr.rev=TRUE}.}

\item{yr.rev}{Deprecated - use age.rev instead}

\item{plot.mean}{The mean ages of the proxy values can be added using \code{plot.mean=TRUE}.}

\item{mean.col}{Colour of the weighted mean ages of the proxy values.}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{yr.lim=NULL}).}

\item{yr.lim}{Deprecated - use age.lim instead}

\item{proxy.lim}{Ranges of the proxy axis, calculated automatically by default (\code{proxy.lim=NULL}).}

\item{sep}{Separator between the fields of the plain text file containing the depth and proxy data.}

\item{xaxs}{Extension of x-axis. By default, no white-space will be added at the axis extremes (\code{xaxs="i"}). See ?par for other options.}

\item{yaxs}{Extension of y-axis. By default, no white-space will be added at the axis extremes (\code{xaxs="i"}). See ?par for other options.}

\item{xaxt}{The x-axis is plotted by default, but this can be switched off using \code{xaxt="n"}.}

\item{yaxt}{The y-axis is plotted by default, but this can be switched off using \code{yaxt="n"}.}

\item{bty}{Type of box to be drawn around the plot (\code{"n"} for none, and \code{"l"} (default), \code{"7"}, \code{"c"}, \code{"u"}, or \code{"o"} for correspondingly shaped boxes).}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{age.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lab}{Deprecated - use age.lab instead}

\item{verbose}{Provide feedback on what is happening (default \code{verbose=TRUE}).}

\item{add}{Add to an existing graph (default \code{add=FALSE}).}
}
\value{
A grey-scale graph of the proxy against calendar age.
}
\description{
Proxies analysed along the depths of a core can be plotted as 'proxy-ghost' graphs against calendar time while taking into account chronological uncertainties. Here darker grey indicates more likely calendar ages for specific proxy value.
}
\details{
Place a csv file with the values of proxies against depth within your core's folder. The values should be in columns separated by commas (default \code{sep=","}), the first column containing the depths and the first line (header) containing the proxy names.
The file name should start with the core's name and end with "_proxies.csv". For an example see \code{"Bacon_coredir/MSB2K/MSB2K_proxies.csv"} or \code{"Cores/MSB2K/MSB2K_proxies.csv"}.
}
\examples{
\donttest{
  Bacon(ask=FALSE, coredir=tempfile())
  layout(1)
  proxy.ghost()
}
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474.
\url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
