% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-futures.R
\name{futures_get}
\alias{futures_get}
\title{Get futures prices from trading session settlements page}
\usage{
futures_get(
  first_date = Sys.Date() - 5,
  last_date = Sys.Date(),
  by = 1,
  cache_folder = cachedir(),
  do_cache = TRUE
)
}
\arguments{
\item{first_date}{First date ("YYYY-MM-DD")}

\item{last_date}{Last date ("YYYY-MM-DD")}

\item{by}{Number of days in between fetched dates (default = 1)}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}
}
\value{
\code{data.frame} with futures prices.
}
\description{
Scrape page \url{https://www.b3.com.br/en_us/market-data-and-indices/data-services/market-data/historical-data/derivatives/trading-session-settlements/}
to get futures prices.
}
\examples{
\dontrun{
df <- futures_get("2022-04-18", "2022-04-22")
}
}
