% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_water.R
\name{add_water}
\alias{add_water}
\title{add_water}
\usage{
add_water(hillshade, watermap, color = "imhof1")
}
\arguments{
\item{hillshade}{A three-dimensional RGB array.}

\item{watermap}{Matrix indicating whether water was detected at that point. 1 indicates water, 0 indicates no water.}

\item{color}{Default `imhof1`. The water fill color. A hexcode or recognized color string. 
Also includes built-in colors to match the palettes included in sphere_shade: 
(`imhof1`,`imhof2`,`imhof3`,`imhof4`, `desert`, `bw`, and `unicorn`).}
}
\description{
Adds a layer of water to a map.
}
\examples{
library(magrittr)
#Here we even out a portion of the volcano dataset to simulate water:
island_volcano = volcano
island_volcano[island_volcano < mean(island_volcano)] = mean(island_volcano)

#Setting a minimum area avoids classifying small flat areas as water:
island_volcano \%>\%
 sphere_shade(texture="imhof3") \%>\%
 add_water(detect_water(island_volcano, min_area = 400),color="imhof3") \%>\%
 plot_map()
}
