% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_preview.R
\name{render_preview}
\alias{render_preview}
\title{Render Preview}
\usage{
render_preview(..., light_direction = c(0, -1, 0), exponent = 6)
}
\arguments{
\item{...}{All arguments that would be passed to `render_scene()`.}

\item{light_direction}{Default `c(0,-1,0)`. Vector specifying the orientation for the global light using for phong shading.}

\item{exponent}{Default `6`. Phong exponent.}
}
\value{
Raytraced plot to current device, or an image saved to a file.
}
\description{
Takes the scene description and renders an image, either to the device or to a filename.
}
\examples{
\donttest{
generate_ground(material=diffuse(color="darkgreen")) \%>\% 
  add_object(sphere(material=diffuse(checkercolor="red"))) \%>\% 
  render_preview()
  
#Change the light direction
generate_ground(material=diffuse(color="darkgreen")) \%>\% 
  add_object(sphere(material=diffuse(checkercolor="red"))) \%>\% 
  render_preview(light_direction = c(-1,-1,0))
  
#Change the Phong exponent
generate_ground(material=diffuse(color="darkgreen")) \%>\% 
  add_object(sphere(material=diffuse(checkercolor="red"))) \%>\% 
  render_preview(light_direction = c(-1,-1,0), exponent=100)
}
}
