% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-docs.R, R/pipeline-install.R,
%   R/pipeline-run.R, R/pipeline-tools.R
\name{rave-pipeline}
\alias{rave-pipeline}
\alias{pipeline_root}
\alias{pipeline_list}
\alias{pipeline_find}
\alias{pipeline_attach}
\alias{pipeline_run}
\alias{pipeline_clean}
\alias{pipeline_run_bare}
\alias{load_targets}
\alias{pipeline_target_names}
\alias{pipeline_debug}
\alias{pipeline_eval}
\alias{pipeline_visualize}
\alias{pipeline_progress}
\alias{pipeline_fork}
\alias{pipeline_build}
\alias{pipeline_read}
\alias{pipeline_vartable}
\alias{pipeline_hasname}
\alias{pipeline_watch}
\alias{pipeline_create_template}
\alias{pipeline_create_subject_pipeline}
\alias{pipeline_description}
\alias{pipeline_load_extdata}
\alias{pipeline_save_extdata}
\alias{pipeline_shared}
\title{'RAVE' pipeline functions}
\usage{
pipeline_root(root_path, temporary = FALSE)

pipeline_list(root_path = pipeline_root())

pipeline_find(name, root_path = pipeline_root())

pipeline_attach(name, root_path = pipeline_root())

pipeline_run(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  scheduler = c("none", "future", "clustermq"),
  type = c("smart", "callr", "vanilla"),
  envir = new.env(parent = globalenv()),
  callr_function = NULL,
  names = NULL,
  async = FALSE,
  check_interval = 0.5,
  progress_quiet = !async,
  progress_max = NA,
  progress_title = "Running pipeline",
  return_values = TRUE,
  ...
)

pipeline_clean(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  destroy = c("all", "cloud", "local", "meta", "process", "progress", "objects",
    "scratch", "workspaces"),
  ask = FALSE
)

pipeline_run_bare(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  scheduler = c("none", "future", "clustermq"),
  type = c("smart", "callr", "vanilla"),
  envir = new.env(parent = globalenv()),
  callr_function = NULL,
  names = NULL,
  return_values = TRUE,
  ...
)

load_targets(..., env = NULL)

pipeline_target_names(pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))

pipeline_debug(
  quick = TRUE,
  env = parent.frame(),
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  skip_names
)

pipeline_eval(
  names,
  env = new.env(parent = parent.frame()),
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  settings_path = file.path(pipe_dir, "settings.yaml")
)

pipeline_visualize(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  glimpse = FALSE,
  targets_only = TRUE,
  shortcut = FALSE,
  zoom_speed = 0.1,
  ...
)

pipeline_progress(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  method = c("summary", "details", "custom"),
  func = targets::tar_progress_summary
)

pipeline_fork(
  src = Sys.getenv("RAVE_PIPELINE", "."),
  dest = tempfile(pattern = "rave_pipeline_"),
  filter_pattern = PIPELINE_FORK_PATTERN,
  activate = FALSE
)

pipeline_build(pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))

pipeline_read(
  var_names,
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  branches = NULL,
  ifnotfound = NULL
)

pipeline_vartable(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  targets_only = TRUE,
  complete_only = FALSE,
  ...
)

pipeline_hasname(var_names, pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))

pipeline_watch(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  targets_only = TRUE,
  ...
)

pipeline_create_template(
  root_path,
  pipeline_name,
  overwrite = FALSE,
  activate = TRUE,
  template_type = c("rmd", "r", "rmd-bare", "rmd-scheduler")
)

pipeline_create_subject_pipeline(
  subject,
  pipeline_name,
  overwrite = FALSE,
  activate = TRUE,
  template_type = c("rmd", "r")
)

pipeline_description(file)

pipeline_load_extdata(
  name,
  format = c("auto", "json", "yaml", "csv", "fst", "rds"),
  error_if_missing = TRUE,
  default_if_missing = NULL,
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  ...
)

pipeline_save_extdata(
  data,
  name,
  format = c("json", "yaml", "csv", "fst", "rds"),
  overwrite = FALSE,
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  ...
)

pipeline_shared(pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))
}
\arguments{
\item{root_path}{the root directory for pipeline templates}

\item{temporary}{whether not to save \code{paths} to current pipeline
root registry. Set this to \code{TRUE} when importing pipelines
from subject pipeline folders}

\item{name, pipeline_name}{the pipeline name to create; usually also the folder}

\item{pipe_dir}{where the pipeline directory is; can be set via system
environment \code{Sys.setenv("RAVE_PIPELINE"=...)}}

\item{scheduler}{how to schedule the target jobs: default is \code{'none'},
which is sequential. If you have multiple heavy-weighted jobs that can be
scheduled at the same time, you can choose \code{'future'} or
\code{'clustermq'}}

\item{type}{how the pipeline should be executed; current choices are
\code{"smart"} to enable 'future' package if possible, \code{'callr'}
to use \code{\link[callr]{r}}, or \code{'vanilla'} to run everything
sequentially in the main session.}

\item{callr_function}{function that will be passed to
\code{\link[targets]{tar_make}}; will be forced to be \code{NULL} if
\code{type='vanilla'}, or \code{\link[callr]{r}} if
\code{type='callr'}}

\item{names}{the names of pipeline targets that are to be executed; default
is \code{NULL}, which runs all targets; use \code{pipeline_target_names}
to check all your available target names.}

\item{async}{whether to run pipeline without blocking the main session}

\item{check_interval}{when running in background (non-blocking mode),
how often to check the pipeline}

\item{progress_title, progress_max, progress_quiet}{control the progress,
see \code{\link[dipsaus]{progress2}}.}

\item{return_values}{whether to return pipeline target values; default is
true; only works in \code{pipeline_run_bare} and will be ignored by
\code{pipeline_run}}

\item{...}{other parameters, targets, etc.}

\item{destroy}{what part of data repository needs to be cleaned}

\item{ask}{whether to ask}

\item{env, envir}{environment to execute the pipeline}

\item{quick}{whether to skip finished targets to save time}

\item{skip_names}{hint of target names to fast skip provided they are
up-to-date; only used when \code{quick=TRUE}. If missing, then
\code{skip_names} will be automatically determined}

\item{settings_path}{path to settings file
name within subject's pipeline path}

\item{glimpse}{whether to hide network status when visualizing the pipelines}

\item{targets_only}{whether to return the variable table for targets only;
default is true}

\item{shortcut}{whether to display shortcut targets}

\item{zoom_speed}{zoom speed when visualizing the pipeline dependence}

\item{method}{how the progress should be presented; choices are
\code{"summary"}, \code{"details"}, \code{"custom"}. If custom method is
chosen, then \code{func} will be called}

\item{func}{function to call when reading customized pipeline progress;
default is \code{\link[targets]{tar_progress_summary}}}

\item{src, dest}{pipeline folder to copy the pipeline script from and to}

\item{filter_pattern}{file name patterns used to filter the scripts to
avoid copying data files; default is \code{"\\.(R|yaml|txt|csv|fst|conf)$"}}

\item{activate}{whether to activate the new pipeline folder from \code{dest};
default is false}

\item{var_names}{variable name to fetch or to check}

\item{branches}{branch to read from; see \code{\link[targets]{tar_read}}}

\item{ifnotfound}{default values to return if variable is not found}

\item{complete_only}{whether only to show completed and up-to-date target
variables; default is false}

\item{overwrite}{whether to overwrite existing pipeline; default is false
so users can double-check; if true, then existing pipeline, including the
data will be erased}

\item{template_type}{which template type to create; choices are \code{'r'}
or \code{'rmd'}}

\item{subject}{character indicating valid 'RAVE' subject ID, or
\code{\link{RAVESubject}} instance}

\item{file}{path to the 'DESCRIPTION' file under the pipeline folder, or
pipeline collection folder that contains the pipeline information,
structures, dependencies, etc.}

\item{format}{format of the extended data, default is \code{'json'}, other
choices are \code{'yaml'}, \code{'fst'}, \code{'csv'}, \code{'rds'}}

\item{error_if_missing, default_if_missing}{what to do if the extended data
is not found}

\item{data}{extended data to be saved}
}
\value{
\describe{
\item{\code{pipeline_root}}{the root directories of the pipelines}
\item{\code{pipeline_list}}{the available pipeline names under \code{pipeline_root}}
\item{\code{pipeline_find}}{the path to the pipeline}
\item{\code{pipeline_run}}{a \code{\link{PipelineResult}} instance}
\item{\code{load_targets}}{a list of targets to build}
\item{\code{pipeline_target_names}}{a vector of characters indicating the pipeline target names}
\item{\code{pipeline_visualize}}{a widget visualizing the target dependence structure}
\item{\code{pipeline_progress}}{a table of building progress}
\item{\code{pipeline_fork}}{a normalized path of the forked pipeline directory}
\item{\code{pipeline_read}}{the value of corresponding \code{var_names}, or a named list if \code{var_names} has more than one element}
\item{\code{pipeline_vartable}}{a table of summaries of the variables; can raise errors if pipeline has never been executed}
\item{\code{pipeline_hasname}}{logical, whether the pipeline has variable built}
\item{\code{pipeline_watch}}{a basic shiny application to monitor the progress}
\item{\code{pipeline_description}}{the list of descriptions of the pipeline or pipeline collection}
}
}
\description{
Utility functions for 'RAVE' pipelines, currently designed for
internal development use. The infrastructure will be deployed to 'RAVE' in
the future to facilitate the "self-expanding" aim. Please check the official
'RAVE' website.
}
