% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.fit.R
\name{find.leaves}
\alias{find.leaves}
\title{Find all descendant leaves of a node in an hclust tree}
\usage{
find.leaves(ind, merge)
}
\arguments{
\item{ind}{Index of the tree node. For an \code{hclust} tree
of \code{p} leaves, -\code{j} denotes the \code{j}th leaf and \code{k}
denotes the interior node formed at the \code{k}th merging in constructing
the tree. The range of \code{ind} is
\{-1, ..., -p, 1,..., p-1\} where \code{p-1} is the number of interior nodes.}

\item{merge}{A (\code{p-1})-by-2 matrix that encodes the order of
mergings in constructing the tree. \code{merge} uses the same notation for
nodes and mergings in an \code{hclust} object.
See \code{\link[stats]{hclust}} for details.}
}
\value{
Returns a sequence of indices for descendant leaves
in the leaf set \{1, ..., p\}. Unlike the notation used in
\code{ind}, we use positive integers to denote leaves here.
}
\description{
The function recursively finds all leaves that are descendants of a
node in an \code{hclust} tree.
}
\examples{
\dontrun{
hc <- hclust(dist(USArrests), "ave")
# Descendant leaves of the 10th leaf (should be iteself)
find.leaves(-10, hc$merge)

# Descendant leaves of the 10th interior node
find.leaves(10, hc$merge)

# Descendant leaves of the root (should be all leaves)
ind_root <- nrow(hc$merge)
all.equal(find.leaves(ind_root, hc$merge), hc$order)
}

}
