% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raqs-package.R
\docType{package}
\name{raqs-package}
\alias{raqs}
\alias{raqs-package}
\title{raqs: Interface to the US EPA Air Quality System (AQS) API}
\description{
Offers functions for fetching JSON data from the US EPA Air Quality System (AQS) API with options to comply with the API rate limits. See \url{https://aqs.epa.gov/aqsweb/documents/data_api.html} for details of the AQS API.
}
\details{
The 'raqs' package provides an R interface to the US EPA AQS API that
publish data in JSON format. To use this package, you first need to register
for the AQS API and get your API key. Please check \link{aqs_signup} and
\link{set_aqs_user} to set up your API credentials in R.

All main functions, for fetching data from the AQS API, were named with the
following scheme: \verb{aqs_\{service\}}
\itemize{
\item \link{aqs_metadata} returns information about the API.
\item \link{aqs_list} returns variable values you may need to create other service
requests.
\item \link{aqs_monitors} returns operational information about the monitors used to
collect data.
\item \link{aqs_sampledata} returns sample data - the finest grain data reported to
EPA.
\item \link{aqs_dailydata} returns data summarized at the daily level.
\item \link{aqs_quarterlydata} returns data summarized at the calendar quarter level.
\item \link{aqs_annualdata} returns data summarized at the yearly level
\item \link{aqs_qaannualperformanceevaluations} returns pairs of data (known and
measured values) at several concentration levels for gaseous criteria
pollutants.
\item \link{aqs_qablanks} returns concentrations from blank samples.
\item \link{aqs_qacollocatedassessments} returns pairs of PM samples collected at the
same time and place by different samplers.
\item \link{aqs_qaflowrateverifications} returns flow rate checks performed by
monitoring agencies.
\item \link{aqs_qaflowrateaudits} returns flow rate audits data
\item \link{aqs_qaonepointqcrawdata} returns measured versus actual concentration of
one point QC checks.
\item \link{aqs_qapepaudits} returns data related to PM2.5 monitoring system audits.
\item \link{aqs_transactionssample} returns sample data in the transaction format for
AQS.
\item \link{aqs_transactionsqaannualperformanceevaluations} returns pairs of data QA
at several concentration levels in the transaction format for AQS.
}

Each main function has a set of underlying functions that are responsible
for sending requests to specific endpoints (service/filter) and were named
with the following scheme: \verb{\{service\}_\{filter\}}. Please refer to the manual
to see how the aforementioned functions work.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/HimesGroup/raqs}
  \item Report bugs at \url{https://github.com/HimesGroup/raqs/issues}
}

}
\author{
\strong{Maintainer}: Jaehyun Joo \email{jaehyunjoo@outlook.com}

Authors:
\itemize{
  \item Blanca Himes
}

}
