% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RapData.R
\name{make.RapData}
\alias{make.RapData}
\title{Make data for RAP using minimal inputs}
\usage{
make.RapData(pus, species, spaces = NULL, amount.target = 0.2,
  space.target = 0.2, n.demand.points = 100L, kernel.method = c("ks",
  "hypervolume")[1], quantile = 0.5, species.points = NULL,
  n.species.points = ceiling(0.2 * cellStats(species, "sum")),
  include.geographic.space = TRUE, scale = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{pus}{\code{SpatialPolygons} with planning unit data.}

\item{species}{\code{RasterLayer}, \code{RasterStack}, \code{RasterBrick} with species probability distribution data.}

\item{spaces}{\code{list} of/or \code{RasterLayer}, \code{RasterStack}, \code{RasterBrick} representing projects of attribute space over geographic space. Use a \code{list} to denote separate attribute spaces.}

\item{amount.target}{\code{numeric} vector for area targets (\%) for each species. Defaults to 0.2 for each attribute space for each species.}

\item{space.target}{\code{numeric} vector for attribute space targets (\%) for each species. Defaults to 0.2 for each attribute space for each species and each space.}

\item{n.demand.points}{\code{integer} number of demand points to use for each attribute space for each species. Defaults to 100L.}

\item{kernel.method}{\code{character} name of kernel method to use to generate demand points. Use either \code{ks} or \code{hypervolume}.}

\item{quantile}{\code{numeric} quantile to generate demand points within. If 0 then demand points are generated across the full range of values the \code{species.points} intersect. Defaults to 0.5.}

\item{species.points}{\code{list} of/or \code{SpatialPointsDataFrame} or \code{SpatialPoints} with species presence records. Use a \code{list} of objects to represent different species. Must have the same number of elements as \code{species}. If not supplied then use \code{n.species.points} to sample points from the species distributions.}

\item{n.species.points}{\code{numeric} vector specifiying the number points to sample the species distributions to use to generate demand points. Defaults to 20\% of the distribution.}

\item{include.geographic.space}{\code{logical} should the geographic space be considered an attribute space?}

\item{scale}{\code{logical} scale the attribute spaces to unit mean and standard deviation? This prevents overflow. Defaults to \code{TRUE}.}

\item{verbose}{\code{logical} print statements during processing?}

\item{...}{additional arguments to \code{calcBoundaryData} and \code{calcPuVsSpeciesData}.}
}
\description{
This function prepares spatially explicit planning unit, species data, and landscape data layers for RAP processing.
}
\examples{
\dontrun{
# load data
data(cs_pus, cs_spp, cs_space)
# make RapData object using the 1st 10 planning units
x <- make.RapData(cs_pus[1:10,], cs_spp, cs_space, include.geographic.space=TRUE)
print(x)
}
}
\seealso{
\code{\link{RapData-class}}, \code{\link{RapData}}.
}

