% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{excludeOutliersByMask}
\alias{excludeOutliersByMask}
\title{Exclude SD-based outliers}
\usage{
excludeOutliersByMask(x, mask, sdlim = 3)
}
\arguments{
\item{x}{Vector to exclude outliers from.}

\item{mask}{A logical matrix determining which data points to include and which not to.}

\item{sdlim}{Standard deviation limit to apply; 
values beyond are classified as outliers and masked.}
}
\value{
An updated mask.
}
\description{
Different masks (columns of a logical matrix) are applied to the same input vector, 
and outliers in each resulting subvector are marked with \code{FALSE} in the mask.
}
\examples{
x<-rnorm(50)
x[1]<-100
x[2]<-50
mask<-matrix(TRUE,ncol=3,nrow=50)
mask[1,2]<-FALSE
mask[2,3]<-FALSE
excludeOutliersByMask(x,mask)
}
