% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{RankControlHamming-class}
\alias{RankControlHamming}
\alias{RankControlHamming-class}
\title{RankControlHamming Class}
\description{
A S4 class for the Hamming distance model fitting.
It is derived from class \code{\link{RankControl-class}}.
}
\section{Slots}{

\describe{
\item{\code{EM_limit}}{maximum number of EM iteration}

\item{\code{EM_epsilon}}{convergence error for weights and cluster probabilities in EM iteration}

\item{\code{SearchPi0_limit}}{maximum number of iterations in the local search of pi0.}

\item{\code{SearchPi0_FUN}}{a function object that gives a goodness of fit criterion. The default is log likelihood.}

\item{\code{SearchPi0_fast_traversal}}{a logical value. If TRUE (by default), immediately traverse to the neighbour if it is better than the current pi0. Otherwise, check all neighbours and traverse to the best one.}

\item{\code{SearchPi0_show_message}}{a logical value. If TRUE, the location of the current pi0 is shown.}

\item{\code{SearchPi0_neighbour}}{a character string specifying which type of neighbour to use in the local search. Supported values are: "Cayley" to use neighbours in terms of Cayley distance or "Kendall" to use neighbours in terms of Kendall distance.
Note that Kendall neighbours are a subset of Cayley neighbours}
}}
\seealso{
\code{\link{RankData}}, \code{\link{RankInit}}, \code{\link{RankControl}}
}

