% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\docType{methods}
\name{evaluate}
\alias{evaluate}
\alias{evaluate}
\alias{evaluate,missing-method}
\alias{evaluate,character-method}
\title{Evaluation of several randomization procedures with respect to certain desirability
functions applied to specified issues.}
\usage{
evaluate(..., statistic)

\S4method{evaluate}{missing}(..., statistic)

\S4method{evaluate}{character}(..., statistic)
}
\arguments{
\item{...}{at least one object of the class \code{desScores} or a list of objects of 
the class \code{desScores}.}

\item{statistic}{character string that specifies on the basis of which statistic the 
\code{evaluate} function should be applied. The statistic can be chosen from "mean", 
"median", "min" or "max".}
}
\value{
\code{S4} object of class \code{evaluation} Comparison of randomization procedures 
with respect to desirability functions applied to specified issues, summarized by a
prespecified statistic.
}
\description{
Evaluation of several randomization procedures with respect to certain desirability
functions applied to specified issues.
}
\details{
The \code{evaluate} function allows the user to compare and evaluate different 
randomization procedures. It expects a number of objects that result when applying the 
\code{getDesScores} function to an assess object and specified desirability functions. 
The \code{evaluate} function summarizes the desirability scores of each randomization 
procedure on the basis of a prespecified statistic and encorporates them into a data 
frame. If no statistic is specified then it is automatically set to \code{mean}. If 
the function is applied to only one object it corresponds simply to 
\code{summary(getDesScores(...))}.
}
\examples{
# Compare Random Allocation Rule to Big Stick Design with respect to different issues
# and their corresponding desirability functions
issue1 <- corGuess("CS")
issue2 <- corGuess("DS")
RAR <- getAllSeq(rarPar(4))
BSD <- getAllSeq(bsdPar(4, mti = 2))
A1 <- assess(RAR, issue1, issue2)
A2 <- assess(BSD, issue1, issue2)

d1 <- derFunc(TV = 0.1, 0.7, 2)
d2 <- derFunc(0.5, c(0.3, 0.8), c(1, 1))
DesScore <- getDesScores(A1, d1, d2, weights = c(5/6, 1/6))
DesScore2 <- getDesScores(A2, d1, d2, weights = c(5/6, 1/6))

evaluate(DesScore, DesScore2)
evaluate(DesScore, DesScore2, statistic = "max")


}
\references{
D. Schindler \emph{Assessment of Randomization Procedures in the Presence of 
Selection and Chronological Bias}. PhD Thesis.
}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

\code{\link{issues}} for the desirability of randomization sequences

Other desirability topics: \code{\link{derFunc}},
  \code{\link{getDesScores}}, \code{\link{plotDes}},
  \code{\link{plotEv}}, \code{\link{probUnDes}}
}
