% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bmat.R
\name{bmat}
\alias{bmat}
\title{Matrices}
\usage{
bmat(x, rows = TRUE, sep = ",", ...)
}
\arguments{
\item{x}{A data vector, character string, or a list.}

\item{rows}{Logical. If TRUE (the default) the matrix is filled by rows,
otherwise the matrix is filled by columns.}

\item{sep}{Separator string. Values within each row/column of x are
separated by this string. Default is \code{","}.}

\item{...}{Aditional optional arguments.}
}
\description{
Like \code{mat}, \code{bmat} creates a matrix from the given set of values.
These values, however, must be represented by a character string.
}
\details{
Be careful when using \code{R} functions within character strings in the
call to \code{bmat}. The character string is split according to ';' and then
','. For example, \code{mat('rnorm(10)')} will work, but
\code{mat('rnorm(10, mean = 3)')} will result in an error. A work around
would be to use \code{mat('3 + rnorm(10, mean = 3)')}.
}
\examples{
# Construct a block matrix from matrices A1, A2, and A3
A1 <- mat('1, 1; 1, 1')
A2 <- mat('2, 2; 2, 2')
A3 <- mat('3, 3, 3, 3')
bmat('A1, A2; A3')
}
\seealso{
\code{\link{mat}}, \code{\link{dmat}}.
}

