/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.io.DataStreamLoader;
import eu.amidst.core.io.DataStreamWriter;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.models.DAG;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.special.Gamma;

public final class Utils {
    public static <E extends Vector> E normalize(E vector) {
        double sum = Utils.sum(vector);
        for (int i = 0; i < vector.size(); ++i) {
            vector.set(i, vector.get(i) / sum);
        }
        return vector;
    }

    public static <E extends Vector> E logNormalize(E vector) {
        int maxIndex = Utils.maxIndex(vector);
        double maxValue = vector.get(maxIndex);
        for (int i = 0; i < vector.size(); ++i) {
            vector.set(i, vector.get(i) - maxValue);
        }
        return vector;
    }

    public static double sum(Vector vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            sum += vector.get(i);
        }
        return sum;
    }

    public static int maxIndex(Vector vector) {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.get(i) > max)) continue;
            max = vector.get(i);
            index = i;
        }
        if (index == -1) {
            throw new IllegalStateException("There is no maximum. Probably a NaN value.");
        }
        return index;
    }

    public static int minIndex(Vector vector) {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.get(i) < min)) continue;
            min = vector.get(i);
            index = i;
        }
        if (index == -1) {
            throw new IllegalStateException("There is no maximum. Probably a NaN value.");
        }
        return index;
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public static void accumulatedSumVectors(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public static int maxIndex(double[] vals) {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < vals.length; ++i) {
            if (!(vals[i] > max)) continue;
            max = vals[i];
            index = i;
        }
        return index;
    }

    public static double[] normalize(double[] vals) {
        int i;
        double sum = 0.0;
        for (i = 0; i < vals.length; ++i) {
            sum += vals[i];
        }
        i = 0;
        while (i < vals.length) {
            int n = i++;
            vals[n] = vals[n] / sum;
        }
        return vals;
    }

    public static double[] logs2probs(double[] vals) {
        double max = vals[Utils.maxIndex(vals)];
        double[] normalizedVals = new double[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            normalizedVals[i] = Math.exp(vals[i] + max);
        }
        return Utils.normalize(normalizedVals);
    }

    public static List<Variable> getTopologicalOrder(DAG dag) {
        Variables variables = dag.getVariables();
        int nNrOfAtts = variables.getNumberOfVars();
        ArrayList<Variable> order = new ArrayList<Variable>();
        boolean[] bDone = new boolean[variables.getNumberOfVars()];
        for (Variable var : variables) {
            bDone[var.getVarID()] = false;
        }
        for (int iAtt = 0; iAtt < nNrOfAtts; ++iAtt) {
            boolean allParentsDone = false;
            for (Variable var2 : variables) {
                if (bDone[var2.getVarID()]) continue;
                allParentsDone = true;
                boolean iParent = false;
                for (Variable parent : dag.getParentSet(var2)) {
                    allParentsDone = allParentsDone && bDone[parent.getVarID()];
                }
                if (!allParentsDone) continue;
                order.add(var2);
                bDone[var2.getVarID()] = true;
            }
        }
        return order;
    }

    public static int getConditionalDistributionType(Variable amidstVar, BayesianNetwork amidstBN) {
        int type = -1;
        List<Variable> conditioningVariables = ((ConditionalDistribution)amidstBN.getConditionalDistribution(amidstVar)).getConditioningVariables();
        if (amidstVar.isMultinomial() && conditioningVariables.size() > 0) {
            return 0;
        }
        if (amidstVar.isMultinomial() && conditioningVariables.size() == 0) {
            return 4;
        }
        if (amidstVar.isNormal()) {
            boolean multinomialParents = false;
            boolean normalParents = false;
            for (Variable v : conditioningVariables) {
                if (v.isMultinomial()) {
                    multinomialParents = true;
                    continue;
                }
                if (v.isNormal()) {
                    normalParents = true;
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized DistributionType. ");
            }
            if (normalParents && !multinomialParents) {
                return 1;
            }
            if (conditioningVariables.size() == 0) {
                return 5;
            }
            if (!normalParents && multinomialParents) {
                return 2;
            }
            if (normalParents && multinomialParents) {
                return 3;
            }
            throw new IllegalArgumentException("Unrecognized DistributionType. ");
        }
        return type;
    }

    public static double invDigamma(double X) {
        double Y = Math.exp(X);
        for (double L = 1.0; L > 1.0E-7; L /= 2.0) {
            Y += L * Math.signum(X - Gamma.digamma(Y));
        }
        return Y;
    }

    public static void shuffleData(String inputPath, String outputPath) {
        DataOnMemory<DataInstance> dataOnMemory = DataStreamLoader.loadDataOnMemoryFromFile(inputPath);
        Collections.shuffle(dataOnMemory.getList());
        try {
            DataStreamWriter.writeDataToFile(dataOnMemory, outputPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

