/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.SparseVectorDefaultValue;
import eu.amidst.core.utils.Vector;
import java.io.Serializable;

public class ArrayVector
implements MomentParameters,
NaturalParameters,
SufficientStatistics,
Serializable {
    private static final long serialVersionUID = -3436599636425587512L;
    private double[] array;

    public ArrayVector(int size) {
        this.array = new double[size];
    }

    public ArrayVector(double[] vec) {
        this.array = vec;
    }

    public double[] toArray() {
        return this.array;
    }

    public void copy(ArrayVector vector) {
        if (vector.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors with different sizes");
        }
        System.arraycopy(vector.toArray(), 0, this.array, 0, vector.toArray().length);
    }

    @Override
    public double get(int i) {
        return this.array[i];
    }

    @Override
    public void set(int i, double val) {
        this.array[i] = val;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public void sum(Vector vector) {
        if (vector.getClass().isAssignableFrom(ArrayVector.class)) {
            this.sum((ArrayVector)vector);
        } else if (vector.getClass().isAssignableFrom(SparseVectorDefaultValue.class)) {
            this.sum((SparseVectorDefaultValue)vector);
        } else {
            throw new UnsupportedOperationException("Non supported operation");
        }
    }

    public void sum(SparseVectorDefaultValue vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors has different sizes");
        }
        if (vector.getDefaultValue() != 0.0) {
            throw new UnsupportedOperationException("Non supported operation");
        }
        for (Integer i : vector.getNonZeroEntries()) {
            int n = i;
            this.array[n] = this.array[n] + vector.get(i);
        }
    }

    public void sum(ArrayVector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors has different sizes");
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n = i;
            this.array[n] = this.array[n] + vector.array[i];
        }
    }

    @Override
    public void substract(Vector vector) {
        this.substract((ArrayVector)vector);
    }

    public void substract(ArrayVector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors has different sizes");
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n = i;
            this.array[n] = this.array[n] - vector.array[i];
        }
    }

    @Override
    public void copy(Vector vector) {
        this.copy((ArrayVector)vector);
    }

    @Override
    public void divideBy(double val) {
        int i = 0;
        while (i < this.array.length) {
            int n = i++;
            this.array[n] = this.array[n] / val;
        }
    }

    @Override
    public void multiplyBy(double val) {
        int i = 0;
        while (i < this.array.length) {
            int n = i++;
            this.array[n] = this.array[n] * val;
        }
    }

    @Override
    public double dotProduct(Vector vector) {
        if (vector.getClass().isAssignableFrom(ArrayVector.class)) {
            return this.dotProduct((ArrayVector)vector);
        }
        if (vector.getClass().isAssignableFrom(SparseVectorDefaultValue.class)) {
            return this.dotProduct((SparseVectorDefaultValue)vector);
        }
        throw new UnsupportedOperationException("Non supported operation");
    }

    public double dotProduct(SparseVectorDefaultValue vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors has different sizes");
        }
        if (vector.getDefaultValue() != 0.0) {
            throw new UnsupportedOperationException("Non supported operation");
        }
        double sum = 0.0;
        for (Integer i : vector.getNonZeroEntries()) {
            sum += this.array[i] * vector.get(i);
        }
        return sum;
    }

    public double dotProduct(ArrayVector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors has different sizes");
        }
        double sum = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            sum += this.array[i] * vector.array[i];
        }
        return sum;
    }
}

