/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Normal;
import eu.amidst.core.exponentialfamily.EF_NormalParameter;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Map;

public class EF_NormalGivenIndependentNormalGamma
extends EF_ConditionalDistribution {
    Variable meanParameterVariable;
    Variable gammaParameterVariable;

    public EF_NormalGivenIndependentNormalGamma(Variable var_, Variable mean, Variable gamma) {
        this.var = var_;
        this.meanParameterVariable = mean;
        this.gammaParameterVariable = gamma;
        this.parents = new ArrayList();
        this.parents.add(mean);
        this.parents.add(gamma);
        if (!this.var.isNormal()) {
            throw new UnsupportedOperationException("Creating a Normal-Inverse-Gamma EF distribution for a non-gaussian child variable.");
        }
        if (!this.meanParameterVariable.isNormalParameter()) {
            throw new UnsupportedOperationException("Creating a Normal-Inverse-Gamma EF distribution for a non-gaussian parent variable.");
        }
        if (!this.gammaParameterVariable.isGammaParameter()) {
            throw new UnsupportedOperationException("Creating a Normal-Inverse-Gamma EF distribution for a non-inverse-gamma parent variable.");
        }
    }

    public Variable getMeanParameterVariable() {
        return this.meanParameterVariable;
    }

    public Variable getGammaParameterVariable() {
        return this.gammaParameterVariable;
    }

    @Override
    public double getExpectedLogNormalizer(Map<Variable, MomentParameters> momentParents) {
        double meansquare = momentParents.get(this.meanParameterVariable).get(1);
        double invVariance = momentParents.get(this.gammaParameterVariable).get(1);
        double logVar = momentParents.get(this.gammaParameterVariable).get(0);
        return 0.5 * meansquare * invVariance - 0.5 * logVar;
    }

    @Override
    public NaturalParameters getExpectedNaturalFromParents(Map<Variable, MomentParameters> momentParents) {
        double mean = momentParents.get(this.meanParameterVariable).get(0);
        double invVariance = momentParents.get(this.gammaParameterVariable).get(1);
        EF_Normal.ArrayVectorParameter naturalParameters = new EF_Normal.ArrayVectorParameter(2);
        naturalParameters.set(0, mean);
        naturalParameters.set(1, invVariance);
        return naturalParameters;
    }

    @Override
    public NaturalParameters getExpectedNaturalToParent(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        SufficientStatistics naturalParameters = new ArrayVector(2);
        double X = momentChildCoParents.get(this.var).get(0);
        if (this.meanParameterVariable == parent) {
            double invVariance = momentChildCoParents.get(this.gammaParameterVariable).get(1);
            naturalParameters = new EF_NormalParameter.ArrayVectorParameter(2);
            naturalParameters.set(0, X);
            naturalParameters.set(1, invVariance);
        } else {
            double XSquare = momentChildCoParents.get(this.var).get(1);
            double mean = momentChildCoParents.get(this.meanParameterVariable).get(0);
            double meanSquare = momentChildCoParents.get(this.meanParameterVariable).get(1);
            naturalParameters.set(0, 0.5);
            naturalParameters.set(1, -0.5 * (XSquare - 2.0 * X * mean + meanSquare));
        }
        return naturalParameters;
    }

    @Override
    public <E extends ConditionalDistribution> E toConditionalDistribution() {
        throw new UnsupportedOperationException("This method does not make sense. Parameter variables can not be converted. Use insteadpublic ConditionalDistribution toConditionalDistribution(Map<Variable, Vector> expectedValueParameterVariables);");
    }

    @Override
    public double getExpectedLogNormalizer(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        throw new UnsupportedOperationException("No Implemented. This method is no really needed");
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 0;
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        return -0.5 * Math.log(Math.PI * 2);
    }

    @Override
    public double computeLogNormalizer() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public Vector createZeroVector() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public ConditionalDistribution toConditionalDistribution(Map<Variable, Vector> expectedValueParameterVariables) {
        Normal normal = new Normal(this.var);
        normal.setMean(expectedValueParameterVariables.get(this.meanParameterVariable).get(0));
        normal.setVariance(1.0 / expectedValueParameterVariables.get(this.gammaParameterVariable).get(0));
        return normal;
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        throw new UnsupportedOperationException();
    }
}

