/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.DataOnMemoryListContainer;
import eu.amidst.core.datastream.DataStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BatchesSpliterator<T extends DataInstance>
implements Spliterator<DataOnMemory<T>> {
    private final DataStream<T> dataStream;
    private final Spliterator<T> spliterator;
    private final int batchSize;
    private final int characteristics;
    private long est;

    public BatchesSpliterator(DataStream<T> dataStream_, long est, int batchSize) {
        this.dataStream = dataStream_;
        this.spliterator = this.dataStream.stream().spliterator();
        int c = this.spliterator.characteristics();
        this.characteristics = (c & 0x40) != 0 ? c | 0x4000 : c;
        this.est = est;
        this.batchSize = batchSize;
    }

    public BatchesSpliterator(DataStream<T> dataStream_, int batchSize) {
        this(dataStream_, dataStream_.stream().spliterator().estimateSize() / (long)batchSize, batchSize);
    }

    public static <T extends DataInstance> Stream<DataOnMemory<T>> toFixedBatchStream(DataStream<T> dataStream_, int batchSize) {
        return StreamSupport.stream(new BatchesSpliterator<T>(dataStream_, batchSize), true);
    }

    public static <T extends DataInstance> Iterable<DataOnMemory<T>> toFixedBatchIterable(DataStream<T> dataStream_, int batchSize) {
        return new BatchIterator<T>(BatchesSpliterator.toFixedBatchStream(dataStream_, batchSize));
    }

    @Override
    public Spliterator<DataOnMemory<T>> trySplit() {
        HoldingConsumer holder = new HoldingConsumer();
        if (!this.spliterator.tryAdvance(holder)) {
            return null;
        }
        DataOnMemoryListContainer<DataInstance> container = new DataOnMemoryListContainer<DataInstance>(this.dataStream.getAttributes());
        Object[] a = new Object[]{container};
        int j = 0;
        do {
            container.add((DataInstance)holder.value);
        } while (++j < this.batchSize && this.spliterator.tryAdvance(holder));
        if (this.est != Long.MAX_VALUE) {
            --this.est;
        }
        return Spliterators.spliterator(a, 0, 1, this.characteristics());
    }

    @Override
    public boolean tryAdvance(Consumer<? super DataOnMemory<T>> action) {
        HoldingConsumer holder = new HoldingConsumer();
        if (!this.spliterator.tryAdvance(holder)) {
            return false;
        }
        DataOnMemoryListContainer<DataInstance> container = new DataOnMemoryListContainer<DataInstance>(this.dataStream.getAttributes());
        int j = 0;
        do {
            container.add((DataInstance)holder.value);
        } while (++j < this.batchSize && this.spliterator.tryAdvance(holder));
        if (j > 0 && this.est != Long.MAX_VALUE) {
            --this.est;
        }
        if (j > 0) {
            action.accept(container);
            return true;
        }
        return false;
    }

    @Override
    public Comparator<? super DataOnMemory<T>> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    static final class HoldingConsumer<T>
    implements Consumer<T> {
        T value;

        HoldingConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }

    static class BatchIterator<T extends DataInstance>
    implements Iterable<DataOnMemory<T>> {
        Stream<DataOnMemory<T>> stream;

        BatchIterator(Stream<DataOnMemory<T>> stream_) {
            this.stream = stream_;
        }

        @Override
        public Iterator<DataOnMemory<T>> iterator() {
            return this.stream.iterator();
        }
    }
}

