% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribute_scrap.R
\name{attribute_scrap}
\alias{attribute_scrap}
\title{Scraping attributes from HTML elements}
\usage{
attribute_scrap(link, node, attr, askRobot = FALSE)
}
\arguments{
\item{link}{the link of the web page to scrape}

\item{node}{the HTML element to consider}

\item{attr}{the attribute to scrape}

\item{askRobot}{logical. Should the function ask the robots.txt if we're allowed or not to scrape the web page ? Default is FALSE.}
}
\value{
a character vector.
}
\description{
This function is used to scrape attributes from HTML elements
}
\examples{
\donttest{
# Extracting the web links within the World Bank research and publications page

link <- "https://ropensci.org/"

# scraping the class attributes' names from all the anchor

attribute_scrap(link = link, node = "a", attr = "class")
}

}
