% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rake_functions.R
\name{rake}
\alias{rake}
\title{rake}
\usage{
rake(cons, inds, vars, output = "fraction", iterations = 10, ...)
}
\arguments{
\item{cons}{A data frame of constraint variables}

\item{inds}{A data frame of individual--level (survey) data}

\item{vars}{A character string of variables to iterate over}

\item{output}{A string specifying the desired output, either "fraction"
(extract()) or "integer" (integerise())}

\item{iterations}{The number of iterations to perform. Defaults to 10.}

\item{...}{Additional arguments to pass to depending on desired output:
\itemize{
  \item{if "fraction" specify 'id' (see extract() documentation)}
  \item{if "integer" specify 'method' and 'seed' (see integerise()
documentation)}
}}
}
\value{
A data frame with extracted weights (if output == "fraction", the
default) or integerised cases (if output == "integer")
}
\description{
A convenience function wrapping \code{weight()} and \code{extract()} or
\code{weight()} and \code{integerise()}
}
\examples{
## not run
## frac_weights <- rake(cons, inds, vars, output = "fraction",
##                      id = "id")

## int_weight <- rake(cons, inds, vars, output = "integer",
##                    method = "trs", seed = "42")
}
