% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rags2ridgesFused.R
\name{is.Xlist}
\alias{is.Xlist}
\title{Test if fused list-formats are correctly used}
\usage{
is.Xlist(Xlist, Ylist = FALSE, semi = FALSE)
}
\arguments{
\item{Xlist}{A \code{list} of precision matrices of equal size
(\code{Plist}), sample covariance matrices (\code{Slist}), data matrices
(\code{Ylist})}

\item{Ylist}{\code{logical}. Is \code{Xlist} a \code{list} of data matrices
with the same number of columns (\code{Ylist}).}

\item{semi}{\code{logical}. Should the matrices in the list be tested to be
positive semi definite or positive definite?}
}
\value{
Returns \code{TRUE} if all tests are passed, throws error if not.
}
\description{
Function to check if the argument submits to the various \code{list}-formats
used by the fused ridge estimator and related functions are correct. That
is, it tests if generic fused list arguments (such as \code{Slist},
\code{Tlist}, \code{Plist}, \code{Ylist}) are properly formatted.
}
\examples{
Slist <- createS(n = c(4, 6, 9), p = 10)
is.Xlist(Slist, semi = TRUE)
}
\references{
Bilgrau, A.E., Peeters, C.F.W., Eriksen, P.S., Boegsted, M., and
  van Wieringen, W.N. (2020).  Targeted Fused Ridge Estimation of Inverse
  Covariance Matrices from Multiple High-Dimensional Data Classes.  Journal
  of Machine Learning Research, 21(26): 1-52.

  van Wieringen, W.N. & Peeters, C.F.W. (2016).  Ridge Estimation of Inverse
  Covariance Matrices from High-Dimensional Data, Computational Statistics &
  Data Analysis, vol. 103: 284-303.  Also available as arXiv:1403.0904v3
  [stat.ME].
}
\seealso{
\code{\link{ridgeP.fused}}, \code{\link{optPenalty.fused}}
}
\author{
Anders Bilgrau, Carel F.W. Peeters <cf.peeters@vumc.nl>, Wessel N.
  van Wieringen
}
