% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_cf.R
\name{dk_cf}
\alias{dk_cf}
\title{Correction factor for source decay.}
\usage{
dk_cf(half_life, time_unit, date1, date2 = Sys.Date())
}
\arguments{
\item{half_life}{The half-life numeric value}

\item{time_unit, }{acceptable values are years, days, hours, and minutes.
These may be shortened to y, d, h and m. Must be entered in quotes.}

\item{date1}{Source reference date. If units are hours or shorter, include time. Format is "YYYY-mm-dd" for longer half-lives, or "YYYY-mm-dd-HH:MM".}

\item{date2}{Date of interest. Format is same as date1. Default is today's date, obtained from system.}
}
\value{
The decay correction factor from the reference date to the date of interest.
}
\description{
Compute correction value for decay of a single-isotope source.
}
\examples{
dk_cf(half_life = 5.27, time_unit = "y", date1 = "2010-12-01", date2 = "2018-12-01")
#
# example defaulting to today's date:
dk_cf(half_life = 28.79, time_unit = "y", date1 = "2001-01-01")
}
\seealso{
Other decay corrections: \code{\link{dk_activity}},
  \code{\link{dk_pct_to_num_half_life}},
  \code{\link{dk_reverse}}, \code{\link{dk_time}}
}
\concept{decay corrections}
