% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/full_factor.R
\name{summary.full_factor}
\alias{summary.full_factor}
\title{Summary method for the full_factor function}
\usage{
\method{summary}{full_factor}(object, ff_cutoff = 0, ff_sort = FALSE, ...)
}
\arguments{
\item{object}{Return value from \code{\link{full_factor}}}

\item{ff_cutoff}{Show only loadings with (absolute) values above ff_cutoff (default = 0)}

\item{ff_sort}{Sort factor loadings}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the full_factor function
}
\details{
See \url{http://vnijs.github.io/radiant/marketing/full_factor.html} for an example in Radiant
}
\examples{
result <- full_factor("diamonds",c("price","carat","depth","table","x"))
summary(result)
summary(result, ff_cutoff = 0, ff_sort = FALSE)
summary(result, ff_cutoff = 0, ff_sort = TRUE)
summary(result, ff_cutoff = .5, ff_sort = TRUE)
}
\seealso{
\code{\link{full_factor}} to calculate results

\code{\link{plot.full_factor}} to plot results
}

