% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalbin.R
\name{uplift}
\alias{uplift}
\title{Evaluate uplift for different (binary) classification models}
\usage{
uplift(
  dataset,
  pred,
  rvar,
  lev = "",
  tvar,
  tlev = "",
  qnt = 10,
  cost = 1,
  margin = 2,
  scale = 1,
  train = "All",
  data_filter = "",
  arr = "",
  rows = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{pred}{Predictions or predictors}

\item{rvar}{Response variable}

\item{lev}{The level in the response variable defined as success}

\item{tvar}{Treatment variable}

\item{tlev}{The level in the treatment variable defined as the treatment}

\item{qnt}{Number of bins to create}

\item{cost}{Cost for each connection (e.g., email or mailing)}

\item{margin}{Margin on each customer purchase}

\item{scale}{Scaling factor to apply to calculations}

\item{train}{Use data from training ("Training"), test ("Test"), both ("Both"), or all data ("All") to evaluate model evalbin}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{arr}{Expression to arrange (sort) the data on (e.g., "color, desc(price)")}

\item{rows}{Rows to select from the specified dataset}

\item{envir}{Environment to extract data from}
}
\value{
A list of results
}
\description{
Evaluate uplift for different (binary) classification models
}
\details{
Evaluate uplift for different (binary) classification models based on predictions. See \url{https://radiant-rstats.github.io/docs/model/evalbin.html} for an example in Radiant
}
\examples{
data.frame(buy = dvd$buy, pred1 = runif(20000), pred2 = ifelse(dvd$buy == "yes", 1, 0)) \%>\%
  evalbin(c("pred1", "pred2"), "buy") \%>\%
  str()
}
\seealso{
\code{\link{summary.evalbin}} to summarize results

\code{\link{plot.evalbin}} to plot results
}
