% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{plot.regress}
\alias{plot.regress}
\title{Plot method for the regress function}
\usage{
\method{plot}{regress}(
  x,
  plots = "",
  lines = "",
  conf_lev = 0.95,
  intercept = FALSE,
  incl = NULL,
  excl = NULL,
  nrobs = -1,
  shiny = FALSE,
  custom = FALSE,
  ...
)
}
\arguments{
\item{x}{Return value from \code{\link{regress}}}

\item{plots}{Regression plots to produce for the specified regression model. Enter "" to avoid showing any plots (default). "dist" to shows histograms (or frequency bar plots) of all variables in the model. "correlations" for a visual representation of the correlation matrix selected variables. "scatter" to show scatter plots (or box plots for factors) for the response variable with each explanatory variable. "dashboard" for a series of six plots that can be used to evaluate model fit visually. "resid_pred" to plot the explanatory variables against the model residuals. "coef" for a coefficient plot with adjustable confidence intervals and "influence" to show (potentially) influential observations}

\item{lines}{Optional lines to include in the select plot. "line" to include a line through a scatter plot. "loess" to include a polynomial regression fit line. To include both use c("line", "loess")}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{intercept}{Include the intercept in the coefficient plot (TRUE, FALSE). FALSE is the default}

\item{incl}{Which variables to include in a coefficient plot}

\item{excl}{Which variables to exclude in a coefficient plot}

\item{nrobs}{Number of data points to show in scatter plots (-1 for all)}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{https://ggplot2.tidyverse.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the regress function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
result <- regress(diamonds, "price", c("carat", "clarity"))
plot(result, plots = "coef", conf_lev = .99, intercept = TRUE)
\dontrun{
plot(result, plots = "dist")
plot(result, plots = "scatter", lines = c("line", "loess"))
plot(result, plots = "resid_pred", lines = "line")
plot(result, plots = "dashboard", lines = c("line", "loess"))
}
}
\seealso{
\code{\link{regress}} to generate the results

\code{\link{summary.regress}} to summarize results

\code{\link{predict.regress}} to generate predictions
}
