% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{wind.dl_2}
\alias{wind.dl_2}
\alias{[[.rWind_series}
\title{Wind-data download}
\usage{
wind.dl_2(time, lon1, lon2, lat1, lat2, type = "read-data", trace = 1)

\method{[[}{rWind_series}(x, i, exact = TRUE)
}
\arguments{
\item{time}{a scalar or vector of POSIXt or Date objects or an character
which can transformed into those, see example below.
There are currently these options at the GFS database for the hours:
00:00 - 03:00 - 06:00 - 09:00 - 12:00 - 15:00 - 18:00 - 21:00 (UTC) (TO).}

\item{lon1}{Western longitude}

\item{lon2}{Eastern longitude}

\item{lat1}{Southern latitude}

\item{lat2}{Northern latitude}

\item{type}{Output type. "read-data" is selected by default, creating an R
object. If you choose "csv", wind.dl create a a CSV file in your work
directory named "wind_yyyy_mm_dd_tt.csv".}

\item{trace}{if trace = 1 (by default) track downloaded files}

\item{x}{object from which to extract element(s).}

\item{i}{indices specifying elements to extract.}

\item{exact}{Controls possible partial matching (not used yet).}
}
\value{
an object of class \code{rWind_series} or .csv file/s with
U and V vector components and wind direction and speed for each coordinate
in the study area defined by lon1/lon2 and lat1/lat2.
}
\description{
wind.dl_2 downloads time-series wind data from the Global Forecast System
(GFS) of the USA's National Weather Service (NWS)
(https://www.ncei.noaa.gov/products/weather-climate-models/global-forecast).
Wind data are taken from NOAA/NCEP Global Forecast System (GFS) Atmospheric
Model collection. Geospatial resolution is 0.5 degrees (approximately 50 km),
and wind is calculated for Earth surface, at 10 m. More metadata
information:
http://oos.soest.hawaii.edu/erddap/info/NCEP_Global_Best/index.html
}
\details{
To get the same format as wind.dl, you should run \code{tidy} function from
wind.dl_2 output.
The output type is determined by type="csv" or type="read-data". If
type="csv" is selected, the function creates a "wind_yyyy_mm_dd_tt.csv" file
that is downloaded at the work directory. If type="read-data" is selected,
an \code{rWind_series} object is created.
}
\note{
wind.dl_2 requires two dates that represent the boundaries of the time
lapse to download wind series data.
U and V vector components allow you to create wind averages or tendencies
for each coordinate at the study area. Longitude coordinates are
provided by GFS dataset in 0/360 notation and transformed internally into
-180/180. "dir" denotes where the
wind/sea current is going (toward), not from where is coming.
}
\examples{

# Download wind for Iberian Peninsula region at 2015, February 12, 00:00
\dontrun{

wind.dl_2("2018/3/15 9:00:00", -10, 5, 35, 45)

library(lubridate)
dt <- seq(ymd_hms(paste(2018, 1, 1, 00, 00, 00, sep = "-")),
  ymd_hms(paste(2018, 1, 2, 21, 00, 00, sep = "-")),
  by = "3 hours"
)
ww <- wind.dl_2(dt, -10, 5, 35, 45)
tidy(ww)
}

}
\references{
http://www.digital-geography.com/cloud-gis-getting-weather-data/#.WDOWmbV1DCL

http://oos.soest.hawaii.edu/erddap/griddap/NCEP_Global_Best.graph
}
\seealso{
\code{\link{wind.mean}}, \code{\link{wind2raster}},
\code{\link{wind.dl}}, \code{\link{as_datetime}}, \code{\link{as.POSIXct}}
}
\author{
Javier Fernández-López (jflopez.bio@gmail.com)
}
\keyword{~gfs}
\keyword{~wind}
