% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{seaOscar.dl}
\alias{seaOscar.dl}
\title{OSCAR Sea currents data download}
\usage{
seaOscar.dl(yyyy, mm, dd, lon1, lon2, lat1, lat2, type = "read-data",
  trace = 1)
}
\arguments{
\item{yyyy}{Selected year.}

\item{mm}{Selected month.}

\item{dd}{Selected day.}

\item{lon1}{Western longitude}

\item{lon2}{Eastern longitude}

\item{lat1}{Northern latitude}

\item{lat2}{Southern latitude}

\item{type}{Output type. "read-data" is selected by default, creating an R
object. If you choose "csv", seaOscar.dl create a a CSV file in your working
directory named "oscar_yyyy_mm_dd.csv".}

\item{trace}{if trace = 1 (by default) track downloaded files}
}
\value{
"rWind" and "data.frame" class object or .csv file with U and V
vector  components and sea current direction and speed for each coordenate
in the study area defined by lon1/lon2 and lat1/lat2.
}
\description{
seaOscar.dl downloads sea currents data from the Ocean Surface Current Analyses Real-time (OSCAR)
(https://coastwatch.pfeg.noaa.gov/erddap/info/jplOscar_LonPM180/index.html).
Geospatial resolution is 0.33 degrees and sea currents are calculated for
15 m depth. CAUTION: OSCAR database has no data between 0 and 20 longitude
degrees. You can use SCUD databse instead (coming soon...)
}
\details{
The output type is determined by type="csv" or type="read-data". If
type="csv" is selected, the function creates a "sea_yyyy_mm_dd.csv" file
that is downloaded at the work directory. If type="read-data" is selected,
an R object (data.frame) is created.
}
\examples{

# Download sea currents for Galapagos Islands
\dontrun{

seaOscar.dl(2015,1,1,-93,-88,2,-3)

}
}
\references{
http://www.digital-geography.com/cloud-gis-getting-weather-data/#.WDOWmbV1DCL

https://coastwatch.pfeg.noaa.gov/erddap/info/jplOscar_LonPM180/index.html
}
\seealso{
\code{\link{wind.dl_2}}, \code{\link{wind2raster}}
}
\author{
Javier Fernández-López (jflopez@rjb.csic.es)
}
\keyword{~currents}
\keyword{~sea}
