% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ttm}
\alias{ttm}
\title{Tensor Times Matrix (m-Mode Product)}
\usage{
ttm(tnsr, mat, m = NULL)
}
\arguments{
\item{tnsr}{Tensor object with K modes}

\item{mat}{input matrix with same number columns as the \code{m}th mode of \code{tnsr}}

\item{m}{the mode to contract on}
}
\value{
a Tensor object with K modes
}
\description{
Contracted (m-Mode) product between a Tensor of arbitrary number of modes and a matrix. The result is folded back into Tensor.
}
\details{
By definition, \code{rs_unfold(ttm(tnsr,mat),m) = mat\%*\%rs_unfold(tnsr,m)}, so the number of columns in \code{mat} must match the \code{m}th mode of \code{tnsr}. For the math on the m-Mode Product, see Kolda and Bader (2009).
}
\note{
The \code{m}th mode of \code{tnsr} must match the number of columns in \code{mat}. By default, the returned Tensor does not drop any modes equal to 1.
}
\examples{
tnsr <- new("Tensor",3L,c(3L,4L,5L),data=runif(60))
mat <- matrix(runif(50),ncol=5)
ttm(tnsr,mat,m=3)
}
\references{
T. Kolda, B. Bader, "Tensor decomposition and applications". SIAM Applied Mathematics and Applications 2009.
}
\seealso{
\code{\link{ttl}}, \code{\link{rs_unfold-methods}}
}

