% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{modeSum-methods}
\alias{modeSum}
\alias{modeSum,Tensor-method}
\alias{modeSum-methods}
\title{Tensor Sum Across Single Mode}
\usage{
modeSum(tnsr, m, drop)

\S4method{modeSum}{Tensor}(tnsr, m = NULL, drop = FALSE)
}
\arguments{
\item{tnsr}{the Tensor instance}

\item{m}{the index of the mode to sum across}

\item{drop}{whether or not mode m should be dropped}
}
\value{
K-1 or K tensor, where \code{K = x@num_modes}
}
\description{
Given a mode for a K-tensor, this returns the K-1 tensor resulting from summing across that particular mode.
}
\details{
\code{modeSum(tnsr,m=NULL,drop=FALSE)}
}
\examples{
tnsr <- rand_tensor()
modeSum(tnsr,3,drop=TRUE)
}
\seealso{
\code{\link{modeMean}}
}

