% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distmap.R
\name{plot_distmap}
\alias{plot_distmap}
\title{Plot distribution data on map}
\usage{
plot_distmap(x, mapdatabase = "world", region = ".", legend = FALSE,
  panel = FALSE, interactive = TRUE, jitter = position_jitter(width =
  0, height = 0), plot = TRUE, gazetter = TRUE)
}
\arguments{
\item{x}{an object of class "\code{records}", see \link{symbiota}}

\item{mapdatabase}{The map database to use in mapping. What you choose here
determines what you can choose in the region parameter. One of: county,
state, usa, world, world2, france, italy, or nz.}

\item{region}{The region of the world to map. From the maps package, run
\code{sort(unique(map_data("world")$region))} to see region names for the
world database layer, or e.g., \code{sort(unique(map_data("state")$region))}
for the state layer.}

\item{legend}{logical}

\item{panel}{plots panels for each species for species above threshold supplied to \code{panel}, e.g., 1000}

\item{interactive}{logical, if TRUE map will be plotted using function \code{mapview::mapview}}

\item{jitter}{If you use jitter, the amount by which to jitter
points in width, height, or both.}

\item{plot}{logical}

\item{gazetter}{logical if Gazetter should be used to add long lat for USA counties where coordinates are missing; default = TRUE}
}
\value{
Map (using \link{ggplot2} package) of points or tiles on a world map.
}
\description{
Plot distribution data on map
}
\examples{
\dontrun{
am.dist <- symbiota(taxon = "Amanita muscaria", db = "MyCoPortal")
head(recordsTable(am.dist))
plot_distmap(am.dist, mapdatabase = "state", interactive = TRUE)
plot_distmap(am.dist, mapdatabase = "state", interactive = FALSE)
}
}
\author{
Franz-Sebastian Krah
}
