/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.antlr.base.mod;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;

class CompileFunction
extends PyBuiltinFunction {
    CompileFunction() {
        super("compile", "compile(source, filename, mode[, flags[, dont_inherit]]) -> code object\n\nCompile the source string (a Python module, statement or expression)\ninto a code object that can be executed by the exec statement or eval().\nThe filename will be used for run-time error messages.\nThe mode must be 'exec' to compile a module, 'single' to compile a\nsingle (interactive) statement, or 'eval' to compile an expression.\nThe flags argument, if present, controls which future statements influence\nthe compilation of the code.\nThe dont_inherit argument, if non-zero, stops the compilation inheriting\nthe effects of any future statements in effect in the code calling\ncompile; if absent or zero these statements do influence the compilation,\nin addition to any features explicitly specified.");
    }

    public PyObject __call__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("compile", args, kwds, new String[]{"source", "filename", "mode", "flags", "dont_inherit"}, 3);
        PyObject source = ap.getPyObject(0);
        String filename = ap.getString(1);
        String mode = ap.getString(2);
        int flags = ap.getInt(3, 0);
        boolean dont_inherit = ap.getPyObject(4, Py.False).__nonzero__();
        return CompileFunction.compile(source, filename, mode, flags, dont_inherit);
    }

    public static PyObject compile(PyObject source, String filename, String mode) {
        return CompileFunction.compile(source, filename, mode, 0, false);
    }

    public static PyObject compile(PyObject source, String filename, String mode, int flags, boolean dont_inherit) {
        if ((flags & 0xFFFF18EF) != 0) {
            throw Py.ValueError("compile(): unrecognised flags");
        }
        if (!(mode.equals("exec") || mode.equals("eval") || mode.equals("single"))) {
            throw Py.ValueError("compile() arg 3 must be 'exec' or 'eval' or 'single'");
        }
        mod ast = CompileFunction.py2node(source);
        if (ast != null) {
            return Py.compile_flags(ast, filename, mode, Py.getCompilerFlags(flags, dont_inherit));
        }
        if (!(source instanceof PyString)) {
            throw Py.TypeError("expected a readable buffer object");
        }
        if (source instanceof PyUnicode) {
            flags |= 0x100;
        }
        return Py.compile_flags(((PyString)source).toString(), filename, mode, Py.getCompilerFlags(flags, dont_inherit));
    }

    private static mod py2node(PyObject obj) {
        Object node = obj.__tojava__(mod.class);
        if (node == Py.NoConversion) {
            return null;
        }
        return (mod)node;
    }
}

