/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyTuple$PyExposer;
import org.python.core.PyTupleDerived;
import org.python.core.PyType;
import org.python.expose.ExposedNew;

public class PyTuple
extends PySequenceList {
    public static final PyType TYPE;

    public PyTuple() {
        this(TYPE, Py.EmptyObjects);
    }

    public PyTuple(PyObject ... elements) {
        this(TYPE, elements);
    }

    public PyTuple(PyType subtype, PyObject[] elements) {
        super(subtype, elements);
    }

    @ExposedNew
    static final PyObject tuple_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("tuple", args, keywords, new String[]{"sequence"}, 0);
        PyObject S = ap.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyTuple();
            }
            if (S instanceof PyTupleDerived) {
                return new PyTuple(((PyTuple)S).getArray());
            }
            if (S instanceof PyTuple) {
                return S;
            }
            return new PyTuple(Py.make_array(S));
        }
        if (S == null) {
            return new PyTupleDerived(subtype, Py.EmptyObjects);
        }
        return new PyTupleDerived(subtype, Py.make_array(S));
    }

    public static PyTuple fromIterable(PyObject iterable) {
        return new PyTuple(Py.make_array(iterable));
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyTuple.sliceLength(start, stop, step);
        PyObject[] newArray = new PyObject[n];
        PyObject[] array = this.getArray();
        if (step == 1) {
            System.arraycopy(array, start, newArray, 0, stop - start);
            return new PyTuple(newArray);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newArray[j] = array[i];
            ++j;
            i += step;
        }
        return new PyTuple(newArray);
    }

    protected PyObject repeat(int count) {
        int newSize;
        int size;
        if (count < 0) {
            count = 0;
        }
        if ((size = this.size()) == 0 || count == 1) {
            if (this.getType() == TYPE) {
                return this;
            }
            if (size == 0) {
                return new PyTuple();
            }
        }
        if ((newSize = size * count) / size != count) {
            throw Py.MemoryError("");
        }
        PyObject[] array = this.getArray();
        PyObject[] newArray = new PyObject[newSize];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(array, 0, newArray, i * size, size);
        }
        return new PyTuple(newArray);
    }

    public int __len__() {
        return this.tuple___len__();
    }

    final int tuple___len__() {
        return this.size();
    }

    final boolean tuple___contains__(PyObject o) {
        return super.__contains__(o);
    }

    final PyObject tuple___ne__(PyObject o) {
        return super.__ne__(o);
    }

    final PyObject tuple___eq__(PyObject o) {
        return super.__eq__(o);
    }

    final PyObject tuple___gt__(PyObject o) {
        return super.__gt__(o);
    }

    final PyObject tuple___ge__(PyObject o) {
        return super.__ge__(o);
    }

    final PyObject tuple___lt__(PyObject o) {
        return super.__lt__(o);
    }

    final PyObject tuple___le__(PyObject o) {
        return super.__le__(o);
    }

    public PyObject __add__(PyObject generic_other) {
        return this.tuple___add__(generic_other);
    }

    final PyObject tuple___add__(PyObject generic_other) {
        PyTuple sum = null;
        if (generic_other instanceof PyTuple) {
            PyTuple otherTuple = (PyTuple)generic_other;
            PyObject[] array = this.getArray();
            PyObject[] otherArray = otherTuple.getArray();
            int thisLen = this.size();
            int otherLen = otherTuple.size();
            PyObject[] newArray = new PyObject[thisLen + otherLen];
            System.arraycopy(array, 0, newArray, 0, thisLen);
            System.arraycopy(otherArray, 0, newArray, thisLen, otherLen);
            sum = new PyTuple(newArray);
        }
        return sum;
    }

    public PyObject __mul__(PyObject o) {
        return this.tuple___mul__(o);
    }

    final PyObject tuple___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    public PyObject __rmul__(PyObject o) {
        return this.tuple___rmul__(o);
    }

    final PyObject tuple___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    public PyObject __iter__() {
        return this.tuple___iter__();
    }

    public PyObject tuple___iter__() {
        return new PyFastSequenceIter(this);
    }

    final PyObject tuple___getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        return this.seq___getslice__(s_start, s_stop, s_step);
    }

    final PyObject tuple___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    final PyTuple tuple___getnewargs__() {
        return new PyTuple(new PyTuple(this.list.getArray()));
    }

    public PyTuple __getnewargs__() {
        return this.tuple___getnewargs__();
    }

    public int hashCode() {
        return this.tuple___hash__();
    }

    final int tuple___hash__() {
        int len = this.size();
        int mult = 1000003;
        int x = 3430008;
        PyObject[] array = this.getArray();
        while (--len >= 0) {
            int y = array[len].hashCode();
            x = (x ^ y) * mult;
            mult += 82520 + len + len;
        }
        return x + 97531;
    }

    private String subobjRepr(PyObject o) {
        if (o == null) {
            return "null";
        }
        return o.__repr__().toString();
    }

    public String toString() {
        return this.tuple___repr__();
    }

    final String tuple___repr__() {
        StringBuffer buf = new StringBuffer("(");
        PyObject[] array = this.getArray();
        int arrayLen = this.size();
        for (int i = 0; i < arrayLen - 1; ++i) {
            buf.append(this.subobjRepr(array[i]));
            buf.append(", ");
        }
        if (arrayLen > 0) {
            buf.append(this.subobjRepr(array[arrayLen - 1]));
        }
        if (arrayLen == 1) {
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public List subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator i;
            {
                this.i = PyTuple.this.list.iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                return this.i.next();
            }
        };
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            ListIterator i;
            {
                this.i = PyTuple.this.list.listIterator(index);
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                return this.i.next();
            }

            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public Object previous() {
                return this.i.previous();
            }

            public int nextIndex() {
                return this.i.nextIndex();
            }

            public int previousIndex() {
                return this.i.previousIndex();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate tuple (not \"{2}\") to tuple";
        }
        return super.unsupportedopMessage(op, o2);
    }

    static {
        PyType.addBuilder(PyTuple.class, new PyTuple$PyExposer());
        TYPE = PyType.fromClass(PyTuple.class);
    }
}

