% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{rspde.make.index}
\alias{rspde.make.index}
\title{rSPDE model index vector generation}
\usage{
rspde.make.index(
  name,
  n.spde = NULL,
  n.group = 1,
  n.repl = 1,
  mesh = NULL,
  rspde_order = 2,
  nu = NULL,
  dim = NULL
)
}
\arguments{
\item{name}{A character string with the base name of the effect.}

\item{n.spde}{The number of basis functions in the mesh model.}

\item{n.group}{The size of the group model.}

\item{n.repl}{The total number of replicates.}

\item{mesh}{An \code{inla.mesh} or
an \code{inla.mesh.1d} object.}

\item{rspde_order}{The order of the rational approximation}

\item{nu}{If \code{NULL}, then the model will assume that nu will be estimated. If
nu is fixed, you should provide the value of nu.}

\item{dim}{the dimension of the domain. Should only be provided if 
\code{mesh} is not provided.}
}
\value{
A list of named index vectors.
\item{name}{Indices into the vector of latent variables}
\item{name.group}{'group' indices}
\item{name.repl}{Indices for replicates}
}
\description{
Generates a list of named index vectors for an rSPDE model.
}
\examples{
\donttest{
library(INLA)
set.seed(123)

loc <- matrix(runif(150 * 2), 150, 2)
mesh <- inla.mesh.2d(loc = loc, max.edge = c(0.1, 0.5))
rspde <- rspde.matern(mesh)
index <- rspde.make.index(name = "spatial", n.spde = rspde$n.spde,
                          n.repl = 2, dim = 2)
spatial.A <- rspde.make.A(mesh=mesh, loc=loc,
                          index = rep(1:nrow(loc), 2),
                          repl = rep(1:2, each = nrow(loc))
)
y <- 10 + rnorm(150 * 2)
stack <- inla.stack(
  data = list(y = y),
  A = list(spatial.A),
  effects = list(c(index, list(intercept = 1))),
  tag = "tag"
)
data <- inla.stack.data(stack, spde = rspde)
formula <- y ~ -1 + intercept + f(spatial,
                                  model = rspde,
                                  replicate = spatial.repl
)
result <- inla(formula,
               family = "gaussian", data = data,
               control.predictor = list(A = inla.stack.A(stack))
)
result <- rspde.result(result, "spatial", rspde)
plot(result)
}
}
