% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_fasta_text_to_list.R
\name{FastaSequence}
\alias{FastaSequence}
\title{Create a FASTA Sequence Data Structure}
\usage{
FastaSequence(entity_id, chains, sequence, fasta_header)
}
\arguments{
\item{entity_id}{A string representing the entity ID of the sequence.}

\item{chains}{A character vector of chain identifiers associated with the sequence.}

\item{sequence}{A string representing the nucleotide or amino acid sequence.}

\item{fasta_header}{A string representing the header of the FASTA sequence.}
}
\value{
A list representing the FASTA sequence, including entity ID, chains, the sequence itself, and the FASTA header.
}
\description{
This function constructs a FASTA sequence data structure from given parameters.
It is typically used to format and store FASTA sequence information.
}
\examples{
fasta_data <- FastaSequence("1XYZ", c("A", "B"), "MVLSPADKT", "header_info")
}
