% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.GLM.r
\name{MVP.GLM}
\alias{MVP.GLM}
\title{To perform GWAS with GLM and MLM model and get the P value of SNPs}
\usage{
MVP.GLM(
  phe,
  geno,
  CV = NULL,
  ind_idx = NULL,
  mrk_idx = NULL,
  mrk_bycol = TRUE,
  maxLine = 5000,
  cpu = 1,
  verbose = TRUE
)
}
\arguments{
\item{phe}{phenotype, n * 2 matrix}

\item{geno}{genotype, either m by n or n by m is supportable, m is marker size, n is population size}

\item{CV}{Covariance, design matrix(n * x) for the fixed effects}

\item{ind_idx}{the index of effective genotyped individuals}

\item{mrk_idx}{the index of effective markers used in analysis}

\item{mrk_bycol}{whether the markers are stored by columns in genotype (i.e. M is a n by m matrix)}

\item{maxLine}{the number of markers handled at a time, smaller value would reduce the memory cost}

\item{cpu}{number of cpus used for parallel computation}

\item{verbose}{whether to print detail.}
}
\value{
m * 2 matrix, the first column is the SNP effect, the second column is the P values
}
\description{
Build date: Aug 30, 2016
Last update: May 25, 2017
}
\examples{
\donttest{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
idx <- !is.na(phenotype[, 2])
phenotype <- phenotype[idx, ]
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
genotype <- deepcopy(genotype, rows=idx)
print(dim(genotype))

glm <- MVP.GLM(phe=phenotype, geno=genotype, cpu=1)
str(glm)
}
}
\author{
Lilin Yin and Xiaolei Liu
}
