% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMea_filter.R
\name{MEAoutlier}
\alias{MEAoutlier}
\title{Replace outliers with given values}
\usage{
MEAoutlier(mea, threshold = function(x) {     stats::sd(x) * 10 },
  direction = c("greater", "less"), replace = NA)
}
\arguments{
\item{mea}{an object of class \code{MEA} or a list of \code{MEA} objects (see function \code{\link{readMEA}})}

\item{threshold}{a numeric value, or a function returning the threshold value to consider data as outliers.}

\item{direction}{a text string. One of "\code{greater}" or "\code{less}": can be abbreviated.}

\item{replace}{a numeric, NULL, or NA value to use as substitution.}
}
\value{
The same \code{mea} object with all extreme values substituted.
}
\description{
Sometimes motion energy analysis generates excessively high peaks resulting from video artifacts or other anomalies in the video source.
}
\details{
This function allows to substitute the values greater or less than a specific threshold. The default threshold is 10 times the standard deviation of the time-series.
}
\examples{
## read the first 4 minutes of the normal sample
##   (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_raw <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)

## Remove extreme values, higher than 10 times the standard deviation
mea_clean = MEAoutlier(mea_raw, threshold=function(x){sd(x)*10}, direction = "greater")
}
