% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHMsmoothing.r
\name{CHMsmoothing}
\alias{CHMsmoothing}
\title{LiDAR-derived Canopy Height Model (CHM) smoothing}
\usage{
CHMsmoothing(chm, filter, ws, sigma)
}
\arguments{
\item{chm}{A LiDAR-derived Canopy Height Model (CHM) RasterLayer or SpatialGridDataFrame file.}

\item{filter}{Filter type: mean, median, maximum or Gaussian. Default is mean.}

\item{ws}{The dimension of a window size, e.g. 3,5, 7 and so on. Default is 5.}

\item{sigma}{Used only when filter parameter is equal to Gaussian, e.g. 0.5, 1.0, 1.5 and so on. Default is 0.67.}
}
\value{
Returns a CHM-smoothed raster.
}
\description{
LiDAR-derived Canopy Height Model (CHM) smoothing is used to eliminate spurious local maxima caused by tree branches.
}
\examples{

#=======================================================================#
# Importing the LiDAR-derived CHM file
data(chm) # or set a CHM. e.g. chm<-raster("CHM_stand.asc") 

#=======================================================================#
# Example 01: Smoothing the CHM using a Gaussian filter
#=======================================================================#
# Set the ws:
ws<-3 # dimension 3x3

# Set the filter type
filter<-"Gaussian"

# Set the sigma value
sigma<-0.6

# Smoothing CHM
sCHM<-CHMsmoothing(chm, filter, ws, sigma)

#=======================================================================# 
# Example 02: Smoothing the CHM using a mean filter
#=======================================================================#
# Set the ws:
ws<-5 # dimension 5x5

# Set the filter type
filter<-"mean"

# Smoothing and plotting LiDAR-derived CHM 
sCHM<-CHMsmoothing(chm, filter, ws)

}
\seealso{
\code{\link[raster]{focal}} in the \emph{raster} package.
}
\author{
Carlos Alberto Silva.
}
