% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldcp.R
\name{ldcp_run}
\alias{ldcp_run}
\title{Execute the LDCP system}
\usage{
ldcp_run(ldcp, input = NULL)
}
\arguments{
\item{ldcp}{is the \code{\link{ldcp}} system.}

\item{input}{is the system input data. May be a vector, list, or matrix with numbers. It is a new input to the \code{\link{data_structure}} object. By default, is NULL.}
}
\value{
The \code{\link{ldcp}} object that contains the execution results.
}
\description{
Execute the \code{\link{ldcp}} system in order to obtain the linguistic report.
This method follows these three sequential steps 1) Data acquisition, 2) Interpretation and 3)
Report generation.
Data acquisition process gets the input data and prepares the data structure. Then, the data
are interpreted using the GLMP. The result is a set of computational perceptions (CP) that are valid to describe
these data. Finally, the report generation process generates a linguistic report using the report template
and the previous set of CPs.
}
\examples{
\dontrun{my_ldcp <- ldcp_run(my_ldcp)}
}

